/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.client;

import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.client.ReplicationFactor;
import org.apache.hadoop.hdds.client.ReplicationType;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.OzoneClientConfig;
import org.apache.hadoop.ozone.OzoneConfigKeys;
import org.apache.hadoop.ozone.client.ObjectStore;
import org.apache.hadoop.ozone.client.OzoneBucket;
import org.apache.hadoop.ozone.client.OzoneVolume;
import org.apache.hadoop.ozone.client.checksum.BaseFileChecksumHelper;
import org.apache.hadoop.ozone.client.checksum.ChecksumHelperFactory;
import org.apache.hadoop.ozone.client.protocol.ClientProtocol;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.BasicOmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmKeyArgs;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.ozone.shaded.com.google.common.base.Preconditions;
import org.apache.ozone.shaded.org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OzoneClientUtils {
    static final Logger LOG = LoggerFactory.getLogger(OzoneClientUtils.class);

    private OzoneClientUtils() {
    }

    public static BucketLayout resolveLinkBucketLayout(OzoneBucket bucket, ObjectStore objectStore, Set<Pair<String, String>> visited) throws IOException {
        if (bucket.isLink()) {
            OzoneBucket sourceBucket;
            if (!visited.add(Pair.of(bucket.getVolumeName(), bucket.getName()))) {
                throw new OMException("Detected loop in bucket links. Bucket name: " + bucket.getName() + ", Volume name: " + bucket.getVolumeName(), OMException.ResultCodes.DETECTED_LOOP_IN_BUCKET_LINKS);
            }
            try {
                sourceBucket = objectStore.getVolume(bucket.getSourceVolume()).getBucket(bucket.getSourceBucket());
            }
            catch (OMException ex) {
                if (ex.getResult().equals((Object)OMException.ResultCodes.VOLUME_NOT_FOUND) || ex.getResult().equals((Object)OMException.ResultCodes.BUCKET_NOT_FOUND)) {
                    bucket.setSourcePathExist(false);
                    LOG.error("Source Bucket is not found, its orphan bucket and used link bucket {} layout {}", (Object)bucket.getName(), (Object)bucket.getBucketLayout());
                    return bucket.getBucketLayout();
                }
                throw ex;
            }
            if (sourceBucket.isLink()) {
                return OzoneClientUtils.resolveLinkBucketLayout(sourceBucket, objectStore, visited);
            }
        }
        return bucket.getBucketLayout();
    }

    public static ReplicationConfig resolveClientSideReplicationConfig(short replication, ReplicationConfig clientConfiguredReplConfig, ReplicationConfig bucketReplConfig, ConfigurationSource config) {
        boolean isECBucket;
        ReplicationConfig clientDeterminedReplConfig = null;
        boolean bl = isECBucket = bucketReplConfig != null && bucketReplConfig.getReplicationType() == HddsProtos.ReplicationType.EC;
        if (isECBucket) {
            clientDeterminedReplConfig = bucketReplConfig;
        } else {
            boolean isReplicationInSupportedList;
            boolean bl2 = isReplicationInSupportedList = replication == ReplicationFactor.ONE.getValue() || replication == ReplicationFactor.THREE.getValue();
            clientDeterminedReplConfig = isReplicationInSupportedList ? (clientConfiguredReplConfig != null ? ReplicationConfig.adjustReplication(clientConfiguredReplConfig, replication, config) : ReplicationConfig.parse(ReplicationType.RATIS, Short.toString(replication), config)) : clientConfiguredReplConfig;
        }
        return clientDeterminedReplConfig;
    }

    public static ReplicationConfig getClientConfiguredReplicationConfig(ConfigurationSource config) {
        String replication = config.get("ozone.replication");
        if (replication == null) {
            return null;
        }
        return ReplicationConfig.parse(ReplicationType.valueOf(config.get("ozone.replication.type", OzoneConfigKeys.OZONE_REPLICATION_TYPE_DEFAULT)), replication, config);
    }

    public static ReplicationConfig validateAndGetClientReplicationConfig(ReplicationType userPassedType, String userPassedReplication, ConfigurationSource clientSideConfig) {
        ReplicationType clientReplicationType = userPassedType;
        String clientReplication = userPassedReplication;
        String clientConfiguredDefaultType = clientSideConfig.get("ozone.replication.type");
        if (userPassedType == null && clientConfiguredDefaultType != null) {
            clientReplicationType = ReplicationType.valueOf(clientConfiguredDefaultType);
        }
        String clientConfiguredDefaultReplication = clientSideConfig.get("ozone.replication");
        if (userPassedReplication == null && clientConfiguredDefaultReplication != null) {
            clientReplication = clientConfiguredDefaultReplication;
        }
        if (clientReplicationType == null || clientReplication == null) {
            return null;
        }
        return ReplicationConfig.parse(clientReplicationType, clientReplication, clientSideConfig);
    }

    public static FileChecksum getFileChecksumWithCombineMode(OzoneVolume volume, OzoneBucket bucket, String keyName, long length, OzoneClientConfig.ChecksumCombineMode combineMode, ClientProtocol rpcClient) throws IOException {
        Preconditions.checkArgument(length >= 0L);
        if (keyName.isEmpty()) {
            return null;
        }
        OmKeyArgs keyArgs = new OmKeyArgs.Builder().setVolumeName(volume.getName()).setBucketName(bucket.getName()).setKeyName(keyName).setSortDatanodesInPipeline(true).setLatestVersionLocation(true).build();
        OmKeyInfo keyInfo = rpcClient.getOzoneManagerClient().lookupKey(keyArgs);
        BaseFileChecksumHelper helper = ChecksumHelperFactory.getChecksumHelper(keyInfo.getReplicationConfig().getReplicationType(), volume, bucket, keyName, length, combineMode, rpcClient, keyInfo);
        helper.compute();
        return helper.getFileChecksum();
    }

    public static boolean isKeyErasureCode(OmKeyInfo keyInfo) {
        return keyInfo.getReplicationConfig().getReplicationType() == HddsProtos.ReplicationType.EC;
    }

    public static boolean isKeyErasureCode(BasicOmKeyInfo keyInfo) {
        return keyInfo.getReplicationConfig().getReplicationType() == HddsProtos.ReplicationType.EC;
    }

    public static boolean isKeyEncrypted(OmKeyInfo keyInfo) {
        return !Objects.isNull(keyInfo.getFileEncryptionInfo());
    }

    public static int limitValue(int confValue, String confName, int maxLimit) {
        int limitVal = confValue;
        if (confValue > maxLimit) {
            LOG.warn("{} config value is greater than max value : {}, limiting the config value to max value..", (Object)confName, (Object)maxLimit);
            limitVal = maxLimit;
        }
        if (limitVal <= 1) {
            limitVal = 2;
        }
        return limitVal;
    }

    public static void deleteSnapshot(ObjectStore objectStore, String snapshot, String volumeName, String bucketName) {
        try {
            objectStore.deleteSnapshot(volumeName, bucketName, snapshot);
        }
        catch (IOException exception) {
            LOG.warn("Failed to delete the temp snapshot with name {} in bucket {} and volume {} after snapDiff op. Exception : {}", new Object[]{snapshot, bucketName, volumeName, exception.getMessage()});
        }
    }
}

