/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils.db;

import java.util.Objects;
import org.apache.hadoop.hdds.utils.db.CodecBuffer;
import org.apache.hadoop.hdds.utils.db.CodecException;
import org.apache.ozone.shaded.jakarta.annotation.Nonnull;

public interface Codec<T> {
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];

    public Class<T> getTypeClass();

    default public boolean supportCodecBuffer() {
        return false;
    }

    default public CodecBuffer toCodecBuffer(@Nonnull T object, CodecBuffer.Allocator allocator) throws CodecException {
        throw new UnsupportedOperationException();
    }

    default public CodecBuffer toDirectCodecBuffer(@Nonnull T object) throws CodecException {
        return this.toCodecBuffer(object, CodecBuffer.Allocator.getDirect());
    }

    default public CodecBuffer toHeapCodecBuffer(@Nonnull T object) throws CodecException {
        return this.toCodecBuffer(object, CodecBuffer.Allocator.getHeap());
    }

    default public T fromCodecBuffer(@Nonnull CodecBuffer buffer) throws CodecException {
        throw new UnsupportedOperationException();
    }

    default public byte[] toPersistedFormat(T object) throws CodecException {
        Objects.requireNonNull(object, "object == null");
        try {
            return this.toPersistedFormatImpl(object);
        }
        catch (Exception e) {
            throw new CodecException("Failed to serialize " + object + " for " + object.getClass(), e);
        }
    }

    default public byte[] toPersistedFormatImpl(T object) throws Exception {
        throw new UnsupportedOperationException();
    }

    default public T fromPersistedFormat(byte[] rawData) throws CodecException {
        Objects.requireNonNull(rawData, "rawData == null");
        try {
            return this.fromPersistedFormatImpl(rawData);
        }
        catch (Exception e) {
            throw new CodecException("Failed to deserialize rawData (length=" + rawData.length + ") for " + this.getTypeClass(), e);
        }
    }

    default public T fromPersistedFormatImpl(byte[] rawData) throws Exception {
        throw new UnsupportedOperationException();
    }

    public T copyObject(T var1);
}

