/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.ozone;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.InvalidPathException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.TrashPolicyDefault;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.ozone.OFSPath;
import org.apache.hadoop.ozone.om.helpers.OzoneFSUtils;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OzoneTrashPolicy
extends TrashPolicyDefault {
    private static final Logger LOG = LoggerFactory.getLogger(OzoneTrashPolicy.class);
    protected static final Path CURRENT = new Path("Current");
    protected static final int MSECS_PER_MINUTE = 60000;
    private static final FsPermission PERMISSION = new FsPermission(FsAction.ALL, FsAction.NONE, FsAction.NONE);
    private OzoneConfiguration ozoneConfiguration;

    public OzoneConfiguration getOzoneConfiguration() {
        return this.ozoneConfiguration;
    }

    public void initialize(Configuration conf, FileSystem fs) {
        this.fs = fs;
        this.ozoneConfiguration = OzoneConfiguration.of(conf);
        float hadoopTrashInterval = conf.getFloat("fs.trash.interval", 0.0f);
        this.deletionInterval = (long)(conf.getFloat("ozone.fs.trash.interval", hadoopTrashInterval) * 60000.0f);
    }

    public boolean moveToTrash(Path path) throws IOException {
        if (this.validatePath(path)) {
            Path baseTrashPath;
            Path trashPath;
            if (!this.isEnabled()) {
                return false;
            }
            if (!path.isAbsolute()) {
                path = new Path(this.fs.getWorkingDirectory(), path);
            }
            this.fs.getFileStatus(path);
            String qpath = this.fs.makeQualified(path).toString();
            Path trashRoot = this.fs.getTrashRoot(path);
            Path trashCurrent = new Path(trashRoot, CURRENT);
            if (qpath.startsWith(trashRoot.toString())) {
                return false;
            }
            if (trashRoot.getParent().toString().startsWith(qpath)) {
                throw new IOException("Cannot move \"" + path + "\" to the trash, as it contains the trash");
            }
            if (this.fs.getUri().getScheme().equals("ofs")) {
                OFSPath ofsPath = new OFSPath(path, this.ozoneConfiguration);
                Path trimmedVolumeAndBucket = new Path("/" + ofsPath.getKeyName());
                trashPath = this.makeTrashRelativePath(trashCurrent, trimmedVolumeAndBucket);
                baseTrashPath = this.makeTrashRelativePath(trashCurrent, trimmedVolumeAndBucket.getParent());
            } else {
                trashPath = this.makeTrashRelativePath(trashCurrent, path);
                baseTrashPath = this.makeTrashRelativePath(trashCurrent, path.getParent());
            }
            IOException cause = null;
            for (int i = 0; i < 2; ++i) {
                try {
                    if (!this.fs.mkdirs(baseTrashPath, PERMISSION)) {
                        LOG.warn("Can't create(mkdir) trash directory: " + baseTrashPath);
                        return false;
                    }
                }
                catch (FileAlreadyExistsException e) {
                    Path existsFilePath = baseTrashPath;
                    while (!this.fs.exists(existsFilePath)) {
                        existsFilePath = existsFilePath.getParent();
                    }
                    baseTrashPath = new Path(baseTrashPath.toString().replace(existsFilePath.toString(), existsFilePath.toString() + Time.now()));
                    trashPath = new Path(baseTrashPath, trashPath.getName());
                    --i;
                    continue;
                }
                catch (IOException e) {
                    LOG.warn("Can't create trash directory: " + baseTrashPath, (Throwable)e);
                    cause = e;
                    break;
                }
                try {
                    String orig = trashPath.toString();
                    while (this.fs.exists(trashPath)) {
                        trashPath = new Path(orig + Time.now());
                    }
                    boolean renamed = this.fs.rename(path, trashPath);
                    if (!renamed) {
                        LOG.error("Failed to move to trash: {}", (Object)path);
                        throw new IOException("Failed to move to trash: " + path);
                    }
                    LOG.info("Moved: '" + path + "' to trash at: " + trashPath);
                    return true;
                }
                catch (IOException e) {
                    cause = e;
                }
            }
            throw (IOException)new IOException("Failed to move to trash: " + path).initCause(cause);
        }
        return false;
    }

    private boolean validatePath(Path path) throws IOException {
        String key = path.toUri().getPath();
        OFSPath ofsPath = new OFSPath(key.substring(1), this.ozoneConfiguration);
        if (path.isRoot() || ofsPath.isBucket()) {
            throw new IOException("Recursive rm of bucket " + path + " not permitted");
        }
        Path trashRoot = this.fs.getTrashRoot(path);
        LOG.debug("Key path to moveToTrash: {}", (Object)key);
        String trashRootKey = trashRoot.toUri().getPath();
        LOG.debug("TrashrootKey for moveToTrash: {}", (Object)trashRootKey);
        if (!OzoneFSUtils.isValidName(key)) {
            throw new InvalidPathException("Invalid path Name " + key);
        }
        return (!key.contains(".Trash") || !trashRootKey.startsWith(key)) && !key.startsWith(trashRootKey);
    }

    private Path makeTrashRelativePath(Path basePath, Path rmFilePath) {
        return Path.mergePaths((Path)basePath, (Path)rmFilePath);
    }
}

