/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.ozone;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.hdds.scm.storage.ByteBufferStreamOutput;
import org.apache.hadoop.hdds.tracing.TracingUtil;
import org.apache.hadoop.ozone.client.io.ByteBufferOutputStream;

public class OzoneFSDataStreamOutput
extends ByteBufferOutputStream {
    private final ByteBufferStreamOutput byteBufferStreamOutput;

    public OzoneFSDataStreamOutput(ByteBufferStreamOutput byteBufferStreamOutput) {
        this.byteBufferStreamOutput = byteBufferStreamOutput;
    }

    @Override
    public void write(ByteBuffer b, int off, int len) throws IOException {
        this.byteBufferStreamOutput.write(b, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.byteBufferStreamOutput.flush();
    }

    @Override
    public void close() throws IOException {
        this.byteBufferStreamOutput.close();
    }

    public void hflush() throws IOException {
        this.hsync();
    }

    public void hsync() throws IOException {
        TracingUtil.executeInNewSpan("OzoneFSDataStreamOutput.hsync", () -> ((ByteBufferStreamOutput)this.byteBufferStreamOutput).hsync());
    }

    protected ByteBufferStreamOutput getByteBufferStreamOutput() {
        return this.byteBufferStreamOutput;
    }
}

