/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.response.key;

import jakarta.annotation.Nonnull;
import java.io.IOException;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.request.OMClientRequestUtils;
import org.apache.hadoop.ozone.om.response.CleanupTableInfo;
import org.apache.hadoop.ozone.om.response.key.OmKeyResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

@CleanupTableInfo(cleanupTables={"keyTable", "snapshotRenamedTable"})
public class OMKeyRenameResponse
extends OmKeyResponse {
    private String fromKeyName;
    private String toKeyName;
    private OmKeyInfo renameKeyInfo;

    public OMKeyRenameResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse, String fromKeyName, String toKeyName, @Nonnull OmKeyInfo renameKeyInfo) {
        super(omResponse);
        this.fromKeyName = fromKeyName;
        this.toKeyName = toKeyName;
        this.renameKeyInfo = renameKeyInfo;
    }

    public OMKeyRenameResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse, String fromKeyName, String toKeyName, @Nonnull OmKeyInfo renameKeyInfo, BucketLayout bucketLayout) {
        super(omResponse, bucketLayout);
        this.fromKeyName = fromKeyName;
        this.toKeyName = toKeyName;
        this.renameKeyInfo = renameKeyInfo;
    }

    public OMKeyRenameResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse, @Nonnull BucketLayout bucketLayout) {
        super(omResponse, bucketLayout);
        this.checkStatusNotOK();
    }

    @Override
    public void addToDBBatch(OMMetadataManager omMetadataManager, BatchOperation batchOperation) throws IOException {
        String volumeName = this.renameKeyInfo.getVolumeName();
        String bucketName = this.renameKeyInfo.getBucketName();
        String fromDbKey = omMetadataManager.getOzoneKey(volumeName, bucketName, this.fromKeyName);
        omMetadataManager.getKeyTable(this.getBucketLayout()).deleteWithBatch(batchOperation, (Object)fromDbKey);
        omMetadataManager.getKeyTable(this.getBucketLayout()).putWithBatch(batchOperation, (Object)omMetadataManager.getOzoneKey(volumeName, bucketName, this.toKeyName), (Object)this.renameKeyInfo);
        boolean isSnapshotBucket = OMClientRequestUtils.isSnapshotBucket(omMetadataManager, this.renameKeyInfo);
        String renameDbKey = omMetadataManager.getRenameKey(this.renameKeyInfo.getVolumeName(), this.renameKeyInfo.getBucketName(), this.renameKeyInfo.getObjectID());
        String renamedKey = (String)omMetadataManager.getSnapshotRenamedTable().get((Object)renameDbKey);
        if (isSnapshotBucket && renamedKey == null) {
            omMetadataManager.getSnapshotRenamedTable().putWithBatch(batchOperation, (Object)renameDbKey, (Object)fromDbKey);
        }
    }

    public OmKeyInfo getRenameKeyInfo() {
        return this.renameKeyInfo;
    }

    public String getFromKeyName() {
        return this.fromKeyName;
    }

    public String getToKeyName() {
        return this.toKeyName;
    }
}

