/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.lock;

import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.lock.OBSKeyPathLockStrategy;
import org.apache.hadoop.ozone.om.lock.OzoneLockStrategy;
import org.apache.hadoop.ozone.om.lock.RegularBucketLockStrategy;

public class OzoneLockProvider {
    private boolean keyPathLockEnabled;
    private boolean enableFileSystemPaths;

    public OzoneLockProvider(boolean keyPathLockEnabled, boolean enableFileSystemPaths) {
        this.keyPathLockEnabled = keyPathLockEnabled;
        this.enableFileSystemPaths = enableFileSystemPaths;
    }

    public OzoneLockStrategy createLockStrategy(BucketLayout bucketLayout) {
        if (this.keyPathLockEnabled) {
            if (bucketLayout == BucketLayout.OBJECT_STORE) {
                return new OBSKeyPathLockStrategy();
            }
            if (!this.enableFileSystemPaths && bucketLayout == BucketLayout.LEGACY) {
                return new OBSKeyPathLockStrategy();
            }
        }
        return new RegularBucketLockStrategy();
    }
}

