/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.shaded.org.apache.ratis.util;

import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ozone.shaded.org.apache.ratis.util.JavaUtils;

public interface ReflectionUtils {
    public static ClassLoader getClassLoader() {
        return Classes.CLASS_LOADER;
    }

    public static Class<?> getClassByNameOrNull(String name) {
        return ReflectionUtils.getClassByNameOrNull(name, null);
    }

    public static Class<?> getClassByNameOrNull(String name, ClassLoader classLoader) {
        Map map = Classes.getClassMap();
        Class<?> clazz = null;
        WeakReference ref = (WeakReference)map.get(name);
        if (ref != null) {
            clazz = (Class<?>)ref.get();
        }
        if (clazz == null) {
            try {
                clazz = Class.forName(name, true, classLoader != null ? classLoader : Classes.CLASS_LOADER);
            }
            catch (ClassNotFoundException e) {
                map.put(name, new WeakReference<Class>(Classes.NEGATIVE_CACHE_SENTINEL));
                return null;
            }
            map.put(name, new WeakReference(clazz));
            return clazz;
        }
        if (clazz == Classes.NEGATIVE_CACHE_SENTINEL) {
            return null;
        }
        return clazz;
    }

    public static Class<?> getClassByName(String name) throws ClassNotFoundException {
        return ReflectionUtils.getClassByName(name, null);
    }

    public static Class<?> getClassByName(String name, ClassLoader classLoader) throws ClassNotFoundException {
        Class<?> ret = ReflectionUtils.getClassByNameOrNull(name, classLoader);
        if (ret == null) {
            throw new ClassNotFoundException("Class " + name + " not found");
        }
        return ret;
    }

    public static <T> T newInstance(Class<T> clazz) {
        return ReflectionUtils.newInstance(clazz, Classes.EMPTY_ARRAY, new Object[0]);
    }

    public static <T> T newInstance(Class<T> clazz, Class<?>[] argClasses, Object ... args2) {
        Constructor ctor;
        try {
            ctor = Constructors.get(clazz, argClasses);
        }
        catch (NoSuchMethodException e) {
            throw new UnsupportedOperationException("Unable to find suitable constructor for class " + clazz.getName() + ", argument classes = " + Arrays.toString(argClasses), e);
        }
        return ReflectionUtils.instantiate(clazz.getName(), ctor, args2);
    }

    public static <T> T instantiate(String className, Constructor<T> ctor, Object[] ctorArgs) {
        try {
            ctor.setAccessible(true);
            return ctor.newInstance(ctorArgs);
        }
        catch (IllegalAccessException e) {
            throw new UnsupportedOperationException("Unable to access specified class " + className, e);
        }
        catch (InstantiationException e) {
            throw new UnsupportedOperationException("Unable to instantiate specified class " + className, e);
        }
        catch (InvocationTargetException e) {
            throw new UnsupportedOperationException("Constructor threw an exception for " + className, e);
        }
    }

    public static boolean isInstance(Object obj, Class<?> ... classes) {
        for (Class<?> c : classes) {
            if (!c.isInstance(obj)) continue;
            return true;
        }
        return false;
    }

    public static String getImplClassName(Class<?> clazz) {
        return clazz.getPackage().getName() + ".impl." + JavaUtils.getClassSimpleName(clazz) + "Impl";
    }

    public static <BASE> Class<? extends BASE> getImplClass(Class<BASE> base) {
        return ReflectionUtils.getClass(ReflectionUtils.getImplClassName(base), base);
    }

    public static <BASE> Class<? extends BASE> getClass(String subClassName, Class<BASE> base) {
        try {
            return ReflectionUtils.getClassByName(subClassName, base.getClassLoader()).asSubclass(base);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Failed to get class " + subClassName + " as a subclass of " + base, e);
        }
    }

    public static <T extends Throwable> T instantiateException(Class<T> clazz) throws Exception {
        Constructor<T> c = clazz.getConstructor(new Class[0]);
        c.setAccessible(true);
        return (T)((Throwable)c.newInstance(new Object[0]));
    }

    public static <T extends Throwable> T instantiateException(Class<T> clazz, String message) throws Exception {
        if (message == null) {
            return ReflectionUtils.instantiateException(clazz);
        }
        Constructor<T> c = clazz.getConstructor(String.class);
        c.setAccessible(true);
        return (T)((Throwable)c.newInstance(message));
    }

    public static final class Classes {
        private static final Class<?>[] EMPTY_ARRAY = new Class[0];
        private static final Map<ClassLoader, Map<String, WeakReference<Class<?>>>> CLASSES = new WeakHashMap();
        private static final Class<?> NEGATIVE_CACHE_SENTINEL = NegativeCacheSentinel.class;
        private static final ClassLoader CLASS_LOADER = Optional.ofNullable(Thread.currentThread().getContextClassLoader()).orElseGet(ReflectionUtils.class::getClassLoader);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static Map<String, WeakReference<Class<?>>> getClassMap() {
            Map<String, WeakReference<Class<Object>>> map;
            Map<ClassLoader, Map<String, WeakReference<Class<?>>>> map2 = CLASSES;
            synchronized (map2) {
                map = CLASSES.get(CLASS_LOADER);
                if (map == null) {
                    map = Collections.synchronizedMap(new WeakHashMap());
                    CLASSES.put(CLASS_LOADER, map);
                }
            }
            return map;
        }

        private static final class NegativeCacheSentinel {
            private NegativeCacheSentinel() {
            }
        }
    }

    public static final class Constructors {
        private static final Map<List<Class<?>>, Constructor<?>> CONSTRUCTORS = new ConcurrentHashMap();

        private Constructors() {
        }

        private static <T> Constructor<T> get(Class<T> clazz, Class<?>[] argClasses) throws NoSuchMethodException {
            Objects.requireNonNull(clazz, "clazz == null");
            ArrayList key = new ArrayList(argClasses.length + 1);
            key.add(clazz);
            key.addAll(Arrays.asList(argClasses));
            Constructor<Object> ctor = CONSTRUCTORS.get(key);
            if (ctor == null) {
                ctor = clazz.getDeclaredConstructor(argClasses);
                ctor.setAccessible(true);
                CONSTRUCTORS.put(key, ctor);
            }
            return ctor;
        }
    }
}

