/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.shaded.org.apache.ratis.util;

public final class PlatformUtils {
    public static final boolean PPC_64 = System.getProperties().getProperty("os.arch").contains("ppc64");
    private static final OSType OS_TYPE = PlatformUtils.getOSType();
    public static final boolean OTHER = OS_TYPE == OSType.OS_TYPE_OTHER;
    public static final boolean LINUX = OS_TYPE == OSType.OS_TYPE_LINUX;
    public static final boolean FREEBSD = OS_TYPE == OSType.OS_TYPE_FREEBSD;
    public static final boolean MAC = OS_TYPE == OSType.OS_TYPE_MAC;
    public static final boolean SOLARIS = OS_TYPE == OSType.OS_TYPE_SOLARIS;
    public static final boolean WINDOWS = OS_TYPE == OSType.OS_TYPE_WIN;

    private PlatformUtils() {
    }

    private static OSType getOSType() {
        String osName = System.getProperty("os.name");
        if (osName.startsWith("Windows")) {
            return OSType.OS_TYPE_WIN;
        }
        if (osName.contains("SunOS") || osName.contains("Solaris")) {
            return OSType.OS_TYPE_SOLARIS;
        }
        if (osName.contains("Mac")) {
            return OSType.OS_TYPE_MAC;
        }
        if (osName.contains("FreeBSD")) {
            return OSType.OS_TYPE_FREEBSD;
        }
        if (osName.startsWith("Linux")) {
            return OSType.OS_TYPE_LINUX;
        }
        return OSType.OS_TYPE_OTHER;
    }

    public static enum OSType {
        OS_TYPE_LINUX,
        OS_TYPE_WIN,
        OS_TYPE_SOLARIS,
        OS_TYPE_MAC,
        OS_TYPE_FREEBSD,
        OS_TYPE_OTHER;

    }
}

