/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.opencensus.trace;

import java.util.Arrays;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.opencensus.internal.Utils;

final class BigendianEncoding {
    static final int LONG_BYTES = 8;
    static final int BYTE_BASE16 = 2;
    static final int LONG_BASE16 = 16;
    private static final String ALPHABET = "0123456789abcdef";
    private static final int ASCII_CHARACTERS = 128;
    private static final char[] ENCODING = BigendianEncoding.buildEncodingArray();
    private static final byte[] DECODING = BigendianEncoding.buildDecodingArray();

    private static char[] buildEncodingArray() {
        char[] encoding = new char[512];
        for (int i = 0; i < 256; ++i) {
            encoding[i] = ALPHABET.charAt(i >>> 4);
            encoding[i | 0x100] = ALPHABET.charAt(i & 0xF);
        }
        return encoding;
    }

    private static byte[] buildDecodingArray() {
        byte[] decoding = new byte[128];
        Arrays.fill(decoding, (byte)-1);
        for (int i = 0; i < ALPHABET.length(); ++i) {
            char c = ALPHABET.charAt(i);
            decoding[c] = (byte)i;
        }
        return decoding;
    }

    static long longFromByteArray(byte[] bytes, int offset) {
        Utils.checkArgument(bytes.length >= offset + 8, "array too small");
        return ((long)bytes[offset] & 0xFFL) << 56 | ((long)bytes[offset + 1] & 0xFFL) << 48 | ((long)bytes[offset + 2] & 0xFFL) << 40 | ((long)bytes[offset + 3] & 0xFFL) << 32 | ((long)bytes[offset + 4] & 0xFFL) << 24 | ((long)bytes[offset + 5] & 0xFFL) << 16 | ((long)bytes[offset + 6] & 0xFFL) << 8 | (long)bytes[offset + 7] & 0xFFL;
    }

    static void longToByteArray(long value, byte[] dest, int destOffset) {
        Utils.checkArgument(dest.length >= destOffset + 8, "array too small");
        dest[destOffset + 7] = (byte)(value & 0xFFL);
        dest[destOffset + 6] = (byte)(value >> 8 & 0xFFL);
        dest[destOffset + 5] = (byte)(value >> 16 & 0xFFL);
        dest[destOffset + 4] = (byte)(value >> 24 & 0xFFL);
        dest[destOffset + 3] = (byte)(value >> 32 & 0xFFL);
        dest[destOffset + 2] = (byte)(value >> 40 & 0xFFL);
        dest[destOffset + 1] = (byte)(value >> 48 & 0xFFL);
        dest[destOffset] = (byte)(value >> 56 & 0xFFL);
    }

    static long longFromBase16String(CharSequence chars, int offset) {
        Utils.checkArgument(chars.length() >= offset + 16, "chars too small");
        return ((long)BigendianEncoding.decodeByte(chars.charAt(offset), chars.charAt(offset + 1)) & 0xFFL) << 56 | ((long)BigendianEncoding.decodeByte(chars.charAt(offset + 2), chars.charAt(offset + 3)) & 0xFFL) << 48 | ((long)BigendianEncoding.decodeByte(chars.charAt(offset + 4), chars.charAt(offset + 5)) & 0xFFL) << 40 | ((long)BigendianEncoding.decodeByte(chars.charAt(offset + 6), chars.charAt(offset + 7)) & 0xFFL) << 32 | ((long)BigendianEncoding.decodeByte(chars.charAt(offset + 8), chars.charAt(offset + 9)) & 0xFFL) << 24 | ((long)BigendianEncoding.decodeByte(chars.charAt(offset + 10), chars.charAt(offset + 11)) & 0xFFL) << 16 | ((long)BigendianEncoding.decodeByte(chars.charAt(offset + 12), chars.charAt(offset + 13)) & 0xFFL) << 8 | (long)BigendianEncoding.decodeByte(chars.charAt(offset + 14), chars.charAt(offset + 15)) & 0xFFL;
    }

    static void longToBase16String(long value, char[] dest, int destOffset) {
        BigendianEncoding.byteToBase16((byte)(value >> 56 & 0xFFL), dest, destOffset);
        BigendianEncoding.byteToBase16((byte)(value >> 48 & 0xFFL), dest, destOffset + 2);
        BigendianEncoding.byteToBase16((byte)(value >> 40 & 0xFFL), dest, destOffset + 4);
        BigendianEncoding.byteToBase16((byte)(value >> 32 & 0xFFL), dest, destOffset + 6);
        BigendianEncoding.byteToBase16((byte)(value >> 24 & 0xFFL), dest, destOffset + 8);
        BigendianEncoding.byteToBase16((byte)(value >> 16 & 0xFFL), dest, destOffset + 10);
        BigendianEncoding.byteToBase16((byte)(value >> 8 & 0xFFL), dest, destOffset + 12);
        BigendianEncoding.byteToBase16((byte)(value & 0xFFL), dest, destOffset + 14);
    }

    static void byteToBase16String(byte value, char[] dest, int destOffset) {
        BigendianEncoding.byteToBase16(value, dest, destOffset);
    }

    static byte byteFromBase16String(CharSequence chars, int offset) {
        Utils.checkArgument(chars.length() >= offset + 2, "chars too small");
        return BigendianEncoding.decodeByte(chars.charAt(offset), chars.charAt(offset + 1));
    }

    private static byte decodeByte(char hi, char lo) {
        Utils.checkArgument(lo < '\u0080' && DECODING[lo] != -1, "invalid character " + lo);
        Utils.checkArgument(hi < '\u0080' && DECODING[hi] != -1, "invalid character " + hi);
        int decoded = DECODING[hi] << 4 | DECODING[lo];
        return (byte)decoded;
    }

    private static void byteToBase16(byte value, char[] dest, int destOffset) {
        int b = value & 0xFF;
        dest[destOffset] = ENCODING[b];
        dest[destOffset + 1] = ENCODING[b | 0x100];
    }

    private BigendianEncoding() {
    }
}

