/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.shaded.org.apache.ratis.protocol.exceptions;

import java.util.Collection;
import java.util.Collections;
import org.apache.ozone.shaded.org.apache.ratis.protocol.RaftGroupMemberId;
import org.apache.ozone.shaded.org.apache.ratis.protocol.RaftPeer;
import org.apache.ozone.shaded.org.apache.ratis.protocol.exceptions.RaftException;
import org.apache.ozone.shaded.org.apache.ratis.util.Preconditions;

public class NotLeaderException
extends RaftException {
    private final RaftPeer suggestedLeader;
    private final Collection<RaftPeer> peers;

    public NotLeaderException(RaftGroupMemberId memberId, RaftPeer suggestedLeader, Collection<RaftPeer> peers) {
        super("Server " + memberId + " is not the leader" + (suggestedLeader != null ? ", suggested leader is: " + suggestedLeader : ""));
        this.suggestedLeader = suggestedLeader;
        this.peers = peers != null ? Collections.unmodifiableCollection(peers) : Collections.emptyList();
        Preconditions.assertUnique(this.peers);
    }

    public RaftPeer getSuggestedLeader() {
        return this.suggestedLeader;
    }

    public Collection<RaftPeer> getPeers() {
        return this.peers;
    }
}

