/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.shaded.org.apache.ratis.netty;

import java.security.PrivateKey;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import javax.net.ssl.KeyManager;
import javax.net.ssl.TrustManager;
import org.apache.ozone.shaded.org.apache.ratis.security.TlsConf;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.netty.channel.Channel;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.netty.channel.ChannelFuture;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.netty.channel.EventLoopGroup;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.netty.channel.ServerChannel;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.netty.channel.epoll.Epoll;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.netty.channel.epoll.EpollEventLoopGroup;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.netty.channel.epoll.EpollServerSocketChannel;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.netty.channel.epoll.EpollSocketChannel;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.netty.channel.nio.NioEventLoopGroup;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.netty.channel.socket.SocketChannel;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.netty.channel.socket.nio.NioServerSocketChannel;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.netty.channel.socket.nio.NioSocketChannel;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.netty.handler.ssl.SslContext;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.netty.handler.ssl.SslContextBuilder;
import org.apache.ozone.shaded.org.apache.ratis.util.ConcurrentUtils;
import org.apache.ozone.shaded.org.apache.ratis.util.TimeDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface NettyUtils {
    public static final Logger LOG = LoggerFactory.getLogger(NettyUtils.class);
    public static final TimeDuration CLOSE_TIMEOUT = TimeDuration.valueOf(5L, TimeUnit.SECONDS);

    public static EventLoopGroup newEventLoopGroup(String name, int size, boolean useEpoll) {
        if (useEpoll) {
            if (Epoll.isAvailable()) {
                LOG.info("Create EpollEventLoopGroup for {}; Thread size is {}.", (Object)name, (Object)size);
                return new EpollEventLoopGroup(size, ConcurrentUtils.newThreadFactory(name + "-"));
            }
            Print.epollUnavailability("Failed to create EpollEventLoopGroup for " + name + "; fall back on NioEventLoopGroup.");
        }
        return new NioEventLoopGroup(size, ConcurrentUtils.newThreadFactory(name + "-"));
    }

    public static void setTrustManager(SslContextBuilder b, TlsConf.TrustManagerConf trustManagerConfig) {
        if (trustManagerConfig == null) {
            return;
        }
        TrustManager trustManager = trustManagerConfig.getTrustManager();
        if (trustManager != null) {
            b.trustManager(trustManager);
            return;
        }
        TlsConf.CertificatesConf certificates = trustManagerConfig.getTrustCertificates();
        if (certificates.isFileBased()) {
            b.trustManager(certificates.getFile());
        } else {
            b.trustManager((Iterable)certificates.get());
        }
    }

    public static void setKeyManager(SslContextBuilder b, TlsConf.KeyManagerConf keyManagerConfig) {
        if (keyManagerConfig == null) {
            return;
        }
        KeyManager keyManager = keyManagerConfig.getKeyManager();
        if (keyManager != null) {
            b.keyManager(keyManager);
            return;
        }
        TlsConf.PrivateKeyConf privateKey = keyManagerConfig.getPrivateKey();
        TlsConf.CertificatesConf certificates = keyManagerConfig.getKeyCertificates();
        if (keyManagerConfig.isFileBased()) {
            b.keyManager(certificates.getFile(), privateKey.getFile());
        } else {
            b.keyManager((PrivateKey)privateKey.get(), (Iterable)certificates.get());
        }
    }

    public static SslContextBuilder initSslContextBuilderForServer(TlsConf.KeyManagerConf keyManagerConfig) {
        KeyManager keyManager = keyManagerConfig.getKeyManager();
        if (keyManager != null) {
            return SslContextBuilder.forServer(keyManager);
        }
        TlsConf.PrivateKeyConf privateKey = keyManagerConfig.getPrivateKey();
        TlsConf.CertificatesConf certificates = keyManagerConfig.getKeyCertificates();
        if (keyManagerConfig.isFileBased()) {
            return SslContextBuilder.forServer(certificates.getFile(), privateKey.getFile());
        }
        return SslContextBuilder.forServer((PrivateKey)privateKey.get(), (Iterable)certificates.get());
    }

    public static SslContextBuilder initSslContextBuilderForServer(TlsConf tlsConf) {
        SslContextBuilder b = NettyUtils.initSslContextBuilderForServer(tlsConf.getKeyManager());
        if (tlsConf.isMutualTls()) {
            NettyUtils.setTrustManager(b, tlsConf.getTrustManager());
        }
        return b;
    }

    public static SslContext buildSslContextForServer(TlsConf tlsConf) {
        return NettyUtils.buildSslContext("server", tlsConf, NettyUtils::initSslContextBuilderForServer);
    }

    public static SslContextBuilder initSslContextBuilderForClient(TlsConf tlsConf) {
        SslContextBuilder b = SslContextBuilder.forClient();
        NettyUtils.setTrustManager(b, tlsConf.getTrustManager());
        if (tlsConf.isMutualTls()) {
            NettyUtils.setKeyManager(b, tlsConf.getKeyManager());
        }
        return b;
    }

    public static SslContext buildSslContextForClient(TlsConf tlsConf) {
        return NettyUtils.buildSslContext("client", tlsConf, NettyUtils::initSslContextBuilderForClient);
    }

    public static SslContext buildSslContext(String name, TlsConf tlsConf, Function<TlsConf, SslContextBuilder> builder) {
        SslContext sslContext;
        if (tlsConf == null) {
            return null;
        }
        try {
            sslContext = builder.apply(tlsConf).build();
        }
        catch (Exception e) {
            String message = "Failed to buildSslContext for " + name + " from " + tlsConf;
            throw new IllegalArgumentException(message, e);
        }
        LOG.debug("buildSslContext for {} from {} returns {}", new Object[]{name, tlsConf, sslContext.getClass().getName()});
        return sslContext;
    }

    public static Class<? extends SocketChannel> getSocketChannelClass(EventLoopGroup eventLoopGroup) {
        return eventLoopGroup instanceof EpollEventLoopGroup ? EpollSocketChannel.class : NioSocketChannel.class;
    }

    public static Class<? extends ServerChannel> getServerChannelClass(EventLoopGroup eventLoopGroup) {
        return eventLoopGroup instanceof EpollEventLoopGroup ? EpollServerSocketChannel.class : NioServerSocketChannel.class;
    }

    public static void closeChannel(Channel channel, String name) {
        boolean completed;
        ChannelFuture f = channel.close();
        try {
            completed = f.await(CLOSE_TIMEOUT.getDuration(), CLOSE_TIMEOUT.getUnit());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOG.info("Interrupted closeChannel {} ", (Object)name, (Object)e);
            return;
        }
        if (!completed) {
            LOG.warn("closeChannel {} is not yet completed in {}", (Object)name, (Object)CLOSE_TIMEOUT);
        }
    }

    public static class Print {
        private static final AtomicBoolean PRINTED_EPOLL_UNAVAILABILITY_CAUSE = new AtomicBoolean();

        private Print() {
        }

        static void epollUnavailability(String message) {
            if (!LOG.isWarnEnabled()) {
                return;
            }
            if (PRINTED_EPOLL_UNAVAILABILITY_CAUSE.compareAndSet(false, true)) {
                LOG.warn(message, (Throwable)new IllegalStateException("Epoll is unavailable.", Epoll.unavailabilityCause()));
            } else {
                LOG.warn(message);
            }
        }
    }
}

