/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.shaded.org.apache.commons.validator.routines.checkdigit;

import org.apache.ozone.shaded.org.apache.commons.validator.GenericValidator;
import org.apache.ozone.shaded.org.apache.commons.validator.routines.CodeValidator;
import org.apache.ozone.shaded.org.apache.commons.validator.routines.checkdigit.CheckDigit;
import org.apache.ozone.shaded.org.apache.commons.validator.routines.checkdigit.CheckDigitException;
import org.apache.ozone.shaded.org.apache.commons.validator.routines.checkdigit.ModulusCheckDigit;

public final class CASNumberCheckDigit
extends ModulusCheckDigit {
    private static final long serialVersionUID = -5387334603220786657L;
    private static final CASNumberCheckDigit INSTANCE = new CASNumberCheckDigit();
    private static final String GROUP1 = "(\\d{2,7})";
    private static final String DASH = "(?:\\-)";
    static final String CAS_REGEX = "^(?:(\\d{2,7})(?:\\-)(\\d{2})(?:\\-)(\\d))$";
    private static final int CAS_MIN_LEN = 4;
    private static final int CAS_MAX_LEN = 10;
    static final CodeValidator REGEX_VALIDATOR = new CodeValidator("^(?:(\\d{2,7})(?:\\-)(\\d{2})(?:\\-)(\\d))$", 4, 10, null);
    private static final int[] POSITION_WEIGHT = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};

    public static CheckDigit getInstance() {
        return INSTANCE;
    }

    private CASNumberCheckDigit() {
    }

    @Override
    public String calculate(String code) throws CheckDigitException {
        if (GenericValidator.isBlankOrNull(code)) {
            throw new CheckDigitException("Code is missing");
        }
        int modulusResult = INSTANCE.calculateModulus(code, false);
        return this.toCheckDigit(modulusResult);
    }

    @Override
    public boolean isValid(String code) {
        if (GenericValidator.isBlankOrNull(code)) {
            return false;
        }
        Object cde = REGEX_VALIDATOR.validate(code);
        if (!(cde instanceof String)) {
            return false;
        }
        try {
            int modulusResult = INSTANCE.calculateModulus((String)cde, true);
            return modulusResult == Character.getNumericValue(code.charAt(code.length() - 1));
        }
        catch (CheckDigitException ex) {
            return false;
        }
    }

    @Override
    protected int weightedValue(int charValue, int leftPos, int rightPos) {
        int weight = POSITION_WEIGHT[(rightPos - 1) % 10];
        return charValue * weight;
    }
}

