/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.shaded.org.apache.commons.validator.routines;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.ozone.shaded.org.apache.commons.validator.routines.IBANValidatorStatus;
import org.apache.ozone.shaded.org.apache.commons.validator.routines.RegexValidator;
import org.apache.ozone.shaded.org.apache.commons.validator.routines.checkdigit.IBANCheckDigit;

public class IBANValidator {
    private static final int SHORT_CODE_LEN = 2;
    private static final Validator[] DEFAULT_VALIDATORS = new Validator[]{new Validator("AD", 24, "AD\\d{10}[A-Z0-9]{12}"), new Validator("AE", 23, "AE\\d{21}"), new Validator("AL", 28, "AL\\d{10}[A-Z0-9]{16}"), new Validator("AT", 20, "AT\\d{18}"), new Validator("AZ", 28, "AZ\\d{2}[A-Z]{4}[A-Z0-9]{20}"), new Validator("BA", 20, "BA\\d{18}"), new Validator("BE", 16, "BE\\d{14}"), new Validator("BG", 22, "BG\\d{2}[A-Z]{4}\\d{6}[A-Z0-9]{8}"), new Validator("BH", 22, "BH\\d{2}[A-Z]{4}[A-Z0-9]{14}"), new Validator("BI", 27, "BI\\d{25}"), new Validator("BR", 29, "BR\\d{25}[A-Z]{1}[A-Z0-9]{1}"), new Validator("BY", 28, "BY\\d{2}[A-Z0-9]{4}\\d{4}[A-Z0-9]{16}"), new Validator("CH", 21, "CH\\d{7}[A-Z0-9]{12}"), new Validator("CR", 22, "CR\\d{20}"), new Validator("CY", 28, "CY\\d{10}[A-Z0-9]{16}"), new Validator("CZ", 24, "CZ\\d{22}"), new Validator("DE", 22, "DE\\d{20}"), new Validator("DJ", 27, "DJ\\d{25}"), new Validator("DK", 18, "DK\\d{16}"), new Validator("DO", 28, "DO\\d{2}[A-Z0-9]{4}\\d{20}"), new Validator("EE", 20, "EE\\d{18}"), new Validator("EG", 29, "EG\\d{27}"), new Validator("ES", 24, "ES\\d{22}"), new Validator("FI", 18, "\\d{16}", "AX"), new Validator("FK", 18, "FK\\d{2}[A-Z]{2}\\d{12}"), new Validator("FO", 18, "FO\\d{16}"), new Validator("FR", 27, "\\d{12}[A-Z0-9]{11}\\d{2}", "GF", "GP", "MQ", "RE", "PF", "TF", "YT", "NC", "BL", "MF", "PM", "WF"), new Validator("GB", 22, "\\d{2}[A-Z]{4}\\d{14}", "IM", "JE", "GG"), new Validator("GE", 22, "GE\\d{2}[A-Z]{2}\\d{16}"), new Validator("GI", 23, "GI\\d{2}[A-Z]{4}[A-Z0-9]{15}"), new Validator("GL", 18, "GL\\d{16}"), new Validator("GR", 27, "GR\\d{9}[A-Z0-9]{16}"), new Validator("GT", 28, "GT\\d{2}[A-Z0-9]{24}"), new Validator("HN", 28, "HN\\d{2}[A-Z]{4}\\d{20}"), new Validator("HR", 21, "HR\\d{19}"), new Validator("HU", 28, "HU\\d{26}"), new Validator("IE", 22, "IE\\d{2}[A-Z]{4}\\d{14}"), new Validator("IL", 23, "IL\\d{21}"), new Validator("IQ", 23, "IQ\\d{2}[A-Z]{4}\\d{15}"), new Validator("IS", 26, "IS\\d{24}"), new Validator("IT", 27, "IT\\d{2}[A-Z]{1}\\d{10}[A-Z0-9]{12}"), new Validator("JO", 30, "JO\\d{2}[A-Z]{4}\\d{4}[A-Z0-9]{18}"), new Validator("KW", 30, "KW\\d{2}[A-Z]{4}[A-Z0-9]{22}"), new Validator("KZ", 20, "KZ\\d{5}[A-Z0-9]{13}"), new Validator("LB", 28, "LB\\d{6}[A-Z0-9]{20}"), new Validator("LC", 32, "LC\\d{2}[A-Z]{4}[A-Z0-9]{24}"), new Validator("LI", 21, "LI\\d{7}[A-Z0-9]{12}"), new Validator("LT", 20, "LT\\d{18}"), new Validator("LU", 20, "LU\\d{5}[A-Z0-9]{13}"), new Validator("LV", 21, "LV\\d{2}[A-Z]{4}[A-Z0-9]{13}"), new Validator("LY", 25, "LY\\d{23}"), new Validator("MC", 27, "MC\\d{12}[A-Z0-9]{11}\\d{2}"), new Validator("MD", 24, "MD\\d{2}[A-Z0-9]{20}"), new Validator("ME", 22, "ME\\d{20}"), new Validator("MK", 19, "MK\\d{5}[A-Z0-9]{10}\\d{2}"), new Validator("MN", 20, "MN\\d{18}"), new Validator("MR", 27, "MR\\d{25}"), new Validator("MT", 31, "MT\\d{2}[A-Z]{4}\\d{5}[A-Z0-9]{18}"), new Validator("MU", 30, "MU\\d{2}[A-Z]{4}\\d{19}[A-Z]{3}"), new Validator("NI", 28, "NI\\d{2}[A-Z]{4}\\d{20}"), new Validator("NL", 18, "NL\\d{2}[A-Z]{4}\\d{10}"), new Validator("NO", 15, "NO\\d{13}"), new Validator("OM", 23, "OM\\d{5}[A-Z0-9]{16}"), new Validator("PK", 24, "PK\\d{2}[A-Z]{4}[A-Z0-9]{16}"), new Validator("PL", 28, "PL\\d{26}"), new Validator("PS", 29, "PS\\d{2}[A-Z]{4}[A-Z0-9]{21}"), new Validator("PT", 25, "PT\\d{23}"), new Validator("QA", 29, "QA\\d{2}[A-Z]{4}[A-Z0-9]{21}"), new Validator("RO", 24, "RO\\d{2}[A-Z]{4}[A-Z0-9]{16}"), new Validator("RS", 22, "RS\\d{20}"), new Validator("RU", 33, "RU\\d{16}[A-Z0-9]{15}"), new Validator("SA", 24, "SA\\d{4}[A-Z0-9]{18}"), new Validator("SC", 31, "SC\\d{2}[A-Z]{4}\\d{20}[A-Z]{3}"), new Validator("SD", 18, "SD\\d{16}"), new Validator("SE", 24, "SE\\d{22}"), new Validator("SI", 19, "SI\\d{17}"), new Validator("SK", 24, "SK\\d{22}"), new Validator("SM", 27, "SM\\d{2}[A-Z]{1}\\d{10}[A-Z0-9]{12}"), new Validator("SO", 23, "SO\\d{21}"), new Validator("ST", 25, "ST\\d{23}"), new Validator("SV", 28, "SV\\d{2}[A-Z]{4}\\d{20}"), new Validator("TL", 23, "TL\\d{21}"), new Validator("TN", 24, "TN\\d{22}"), new Validator("TR", 26, "TR\\d{8}[A-Z0-9]{16}"), new Validator("UA", 29, "UA\\d{8}[A-Z0-9]{19}"), new Validator("VA", 22, "VA\\d{20}"), new Validator("VG", 24, "VG\\d{2}[A-Z]{4}\\d{16}"), new Validator("XK", 20, "XK\\d{18}"), new Validator("YE", 30, "YE\\d{2}[A-Z]{4}\\d{4}[A-Z0-9]{18}")};
    public static final IBANValidator DEFAULT_IBAN_VALIDATOR = new IBANValidator();
    private final ConcurrentMap<String, Validator> validatorMap;

    public static IBANValidator getInstance() {
        return DEFAULT_IBAN_VALIDATOR;
    }

    public IBANValidator() {
        this(DEFAULT_VALIDATORS);
    }

    public IBANValidator(Validator[] validators) {
        this.validatorMap = this.createValidators(validators);
    }

    private ConcurrentMap<String, Validator> createValidators(Validator[] validators) {
        ConcurrentHashMap<String, Validator> map = new ConcurrentHashMap<String, Validator>();
        for (Validator validator : validators) {
            map.put(validator.countryCode, validator);
            for (String otherCC : validator.otherCountryCodes) {
                map.put(otherCC, validator);
            }
        }
        return map;
    }

    public Validator[] getDefaultValidators() {
        return Arrays.copyOf(DEFAULT_VALIDATORS, DEFAULT_VALIDATORS.length);
    }

    public Validator getValidator(String code) {
        if (code == null || code.length() < 2) {
            return null;
        }
        String key = code.substring(0, 2);
        return (Validator)this.validatorMap.get(key);
    }

    public boolean hasValidator(String code) {
        return this.getValidator(code) != null;
    }

    public boolean isValid(String code) {
        return this.validate(code) == IBANValidatorStatus.VALID;
    }

    public Validator setValidator(String countryCode, int length, String format) {
        if (this == DEFAULT_IBAN_VALIDATOR) {
            throw new IllegalStateException("The singleton validator cannot be modified");
        }
        if (length < 0) {
            return (Validator)this.validatorMap.remove(countryCode);
        }
        return this.setValidator(new Validator(countryCode, length, format));
    }

    public Validator setValidator(Validator validator) {
        if (this == DEFAULT_IBAN_VALIDATOR) {
            throw new IllegalStateException("The singleton validator cannot be modified");
        }
        return this.validatorMap.put(validator.countryCode, validator);
    }

    public IBANValidatorStatus validate(String code) {
        Validator formatValidator = this.getValidator(code);
        if (formatValidator == null) {
            return IBANValidatorStatus.UNKNOWN_COUNTRY;
        }
        if (code.length() != formatValidator.ibanLength) {
            return IBANValidatorStatus.INVALID_LENGTH;
        }
        if (!formatValidator.regexValidator.isValid(code)) {
            return IBANValidatorStatus.INVALID_PATTERN;
        }
        return IBANCheckDigit.IBAN_CHECK_DIGIT.isValid(code) ? IBANValidatorStatus.VALID : IBANValidatorStatus.INVALID_CHECKSUM;
    }

    public static class Validator {
        private static final int MIN_LEN = 8;
        private static final int MAX_LEN = 34;
        final String countryCode;
        final String[] otherCountryCodes;
        final RegexValidator regexValidator;
        private final int ibanLength;

        public Validator(String countryCode, int ibanLength, String regexWithCC) {
            this(countryCode, ibanLength, regexWithCC.substring(countryCode.length()), new String[0]);
        }

        Validator(String countryCode, int ibanLength, String regexWithoutCC, String ... otherCountryCodes) {
            if (countryCode.length() != 2 || !Character.isUpperCase(countryCode.charAt(0)) || !Character.isUpperCase(countryCode.charAt(1))) {
                throw new IllegalArgumentException("Invalid country Code; must be exactly 2 upper-case characters");
            }
            if (ibanLength > 34 || ibanLength < 8) {
                throw new IllegalArgumentException("Invalid length parameter, must be in range 8 to 34 inclusive: " + ibanLength);
            }
            this.countryCode = countryCode;
            this.otherCountryCodes = (String[])otherCountryCodes.clone();
            ArrayList<String> regexList = new ArrayList<String>(this.otherCountryCodes.length + 1);
            regexList.add(countryCode + regexWithoutCC);
            for (String otherCc : otherCountryCodes) {
                regexList.add(otherCc + regexWithoutCC);
            }
            this.ibanLength = ibanLength;
            this.regexValidator = new RegexValidator(regexList);
        }

        public int getIbanLength() {
            return this.ibanLength;
        }

        public RegexValidator getRegexValidator() {
            return this.regexValidator;
        }
    }
}

