/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.shaded.io.opentelemetry.exporter.internal.otlp.logs;

import java.util.Collection;
import java.util.Deque;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.BiFunction;
import org.apache.ozone.shaded.io.opentelemetry.exporter.internal.marshal.Marshaler;
import org.apache.ozone.shaded.io.opentelemetry.exporter.internal.otlp.logs.LogsRequestMarshaler;
import org.apache.ozone.shaded.io.opentelemetry.exporter.internal.otlp.logs.LowAllocationLogsRequestMarshaler;
import org.apache.ozone.shaded.io.opentelemetry.sdk.common.CompletableResultCode;
import org.apache.ozone.shaded.io.opentelemetry.sdk.common.export.MemoryMode;
import org.apache.ozone.shaded.io.opentelemetry.sdk.logs.data.LogRecordData;

public class LogReusableDataMarshaler {
    private final Deque<LowAllocationLogsRequestMarshaler> marshalerPool = new ConcurrentLinkedDeque<LowAllocationLogsRequestMarshaler>();
    private final MemoryMode memoryMode;
    private final BiFunction<Marshaler, Integer, CompletableResultCode> doExport;

    public LogReusableDataMarshaler(MemoryMode memoryMode, BiFunction<Marshaler, Integer, CompletableResultCode> doExport) {
        this.memoryMode = memoryMode;
        this.doExport = doExport;
    }

    public MemoryMode getMemoryMode() {
        return this.memoryMode;
    }

    public CompletableResultCode export(Collection<LogRecordData> logs) {
        if (this.memoryMode == MemoryMode.REUSABLE_DATA) {
            LowAllocationLogsRequestMarshaler marshaler = this.marshalerPool.poll();
            if (marshaler == null) {
                marshaler = new LowAllocationLogsRequestMarshaler();
            }
            LowAllocationLogsRequestMarshaler exportMarshaler = marshaler;
            exportMarshaler.initialize(logs);
            return this.doExport.apply(exportMarshaler, logs.size()).whenComplete(() -> {
                exportMarshaler.reset();
                this.marshalerPool.add(exportMarshaler);
            });
        }
        LogsRequestMarshaler request = LogsRequestMarshaler.create(logs);
        return this.doExport.apply(request, logs.size());
    }
}

