/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.ha;

import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.ozone.shaded.com.google.common.base.Joiner;
import org.apache.ozone.shaded.org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

public final class ConfUtils {
    private ConfUtils() {
    }

    public static String addSuffix(String key, String suffix) {
        if (suffix == null || suffix.isEmpty()) {
            return key;
        }
        assert (!suffix.startsWith(".")) : "suffix '" + suffix + "' should not already have '.' prepended.";
        return key + "." + suffix;
    }

    public static String addKeySuffixes(String key, String ... suffixes) {
        String keySuffix = ConfUtils.concatSuffixes(suffixes);
        return ConfUtils.addSuffix(key, keySuffix);
    }

    public static String concatSuffixes(String ... suffixes) {
        if (suffixes == null) {
            return null;
        }
        return Joiner.on(".").skipNulls().join(suffixes);
    }

    public static String getConfSuffixedWithServiceId(ConfigurationSource conf, String confKey, String omServiceID, String omNodeId) {
        String suffixedConfKey = ConfUtils.addKeySuffixes(confKey, omServiceID, omNodeId);
        String confValue = conf.getTrimmed(suffixedConfKey);
        if (StringUtils.isNotEmpty(confValue)) {
            return confValue;
        }
        return null;
    }

    public static void setNodeSpecificConfigs(String[] nodeSpecificConfigKeys, OzoneConfiguration ozoneConfiguration, String serviceId, String nodeId, Logger logger) {
        for (String confKey : nodeSpecificConfigKeys) {
            String confValue = ConfUtils.getConfSuffixedWithServiceId(ozoneConfiguration, confKey, serviceId, nodeId);
            if (confValue == null) continue;
            logger.info("Setting configuration key {} with value of key {}: {}", new Object[]{confKey, ConfUtils.addKeySuffixes(confKey, serviceId, nodeId), confValue});
            ozoneConfiguration.set(confKey, confValue);
        }
    }
}

