/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.client;

import java.util.Objects;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.ozone.shaded.com.fasterxml.jackson.annotation.JsonIgnore;

public class ContainerBlockID {
    private final long containerID;
    private final long localID;

    public ContainerBlockID(long containerID, long localID) {
        this.containerID = containerID;
        this.localID = localID;
    }

    public long getContainerID() {
        return this.containerID;
    }

    public long getLocalID() {
        return this.localID;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(48);
        this.appendTo(sb);
        return sb.toString();
    }

    public void appendTo(StringBuilder sb) {
        sb.append("conID: ").append(this.containerID).append(" locID: ").append(this.localID);
    }

    @JsonIgnore
    public HddsProtos.ContainerBlockID getProtobuf() {
        return HddsProtos.ContainerBlockID.newBuilder().setContainerID(this.containerID).setLocalID(this.localID).build();
    }

    @JsonIgnore
    public static ContainerBlockID getFromProtobuf(HddsProtos.ContainerBlockID containerBlockID) {
        return new ContainerBlockID(containerBlockID.getContainerID(), containerBlockID.getLocalID());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContainerBlockID blockID = (ContainerBlockID)o;
        return this.containerID == blockID.containerID && this.localID == blockID.localID;
    }

    public int hashCode() {
        return Objects.hash(this.containerID, this.localID);
    }
}

