/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.stream;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.stream.ChunkedWriteHandler;
import java.net.InetSocketAddress;
import org.apache.hadoop.ozone.container.stream.DirstreamServerHandler;
import org.apache.hadoop.ozone.container.stream.StreamingException;
import org.apache.hadoop.ozone.container.stream.StreamingSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamingServer
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(StreamingServer.class);
    private int port;
    private StreamingSource source;
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;
    private SslContext sslContext;

    public StreamingServer(StreamingSource source, int port) {
        this(source, port, null);
    }

    public StreamingServer(StreamingSource source, int port, SslContext sslContext) {
        this.port = port;
        this.source = source;
        this.sslContext = sslContext;
    }

    public void start() {
        try {
            ServerBootstrap b = new ServerBootstrap();
            this.bossGroup = new NioEventLoopGroup(100);
            this.workerGroup = new NioEventLoopGroup(100);
            ((ServerBootstrap)((ServerBootstrap)b.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, (Object)100)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                public void initChannel(SocketChannel ch) throws Exception {
                    if (StreamingServer.this.sslContext != null) {
                        ch.pipeline().addLast(new ChannelHandler[]{StreamingServer.this.sslContext.newHandler(ch.alloc())});
                    }
                    ch.pipeline().addLast(new ChannelHandler[]{new ChunkedWriteHandler(), new DirstreamServerHandler(StreamingServer.this.source)});
                }
            });
            ChannelFuture f = b.bind(this.port).sync();
            InetSocketAddress socketAddress = (InetSocketAddress)f.channel().localAddress();
            this.port = socketAddress.getPort();
            LOG.info("Started streaming server on {}", (Object)this.port);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new StreamingException(ex);
        }
    }

    public void stop() {
        this.bossGroup.shutdownGracefully();
        this.workerGroup.shutdownGracefully();
    }

    public int getPort() {
        return this.port;
    }

    @Override
    public void close() {
        this.stop();
    }
}

