/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.interfaces;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.Clock;
import java.util.Collection;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.scm.container.common.helpers.StorageContainerException;
import org.apache.hadoop.ozone.container.checksum.ContainerChecksumTreeManager;
import org.apache.hadoop.ozone.container.checksum.ContainerMerkleTreeWriter;
import org.apache.hadoop.ozone.container.checksum.DNContainerOperationClient;
import org.apache.hadoop.ozone.container.common.helpers.BlockData;
import org.apache.hadoop.ozone.container.common.helpers.ContainerMetrics;
import org.apache.hadoop.ozone.container.common.impl.ContainerData;
import org.apache.hadoop.ozone.container.common.impl.ContainerSet;
import org.apache.hadoop.ozone.container.common.interfaces.Container;
import org.apache.hadoop.ozone.container.common.interfaces.ScanResult;
import org.apache.hadoop.ozone.container.common.interfaces.VolumeChoosingPolicy;
import org.apache.hadoop.ozone.container.common.report.IncrementalReportSender;
import org.apache.hadoop.ozone.container.common.transport.server.ratis.DispatcherContext;
import org.apache.hadoop.ozone.container.common.volume.VolumeSet;
import org.apache.hadoop.ozone.container.keyvalue.KeyValueHandler;
import org.apache.hadoop.ozone.container.keyvalue.TarContainerPacker;
import org.apache.ratis.statemachine.StateMachine;

public abstract class Handler {
    protected final ConfigurationSource conf;
    protected final ContainerSet containerSet;
    protected final VolumeSet volumeSet;
    protected String clusterId;
    protected final ContainerMetrics metrics;
    protected String datanodeId;
    private IncrementalReportSender<Container> icrSender;

    protected Handler(ConfigurationSource config, String datanodeId, ContainerSet contSet, VolumeSet volumeSet, ContainerMetrics containerMetrics, IncrementalReportSender<Container> icrSender) {
        this.conf = config;
        this.containerSet = contSet;
        this.volumeSet = volumeSet;
        this.metrics = containerMetrics;
        this.datanodeId = datanodeId;
        this.icrSender = icrSender;
    }

    public static Handler getHandlerForContainerType(ContainerProtos.ContainerType containerType, ConfigurationSource config, String datanodeId, ContainerSet contSet, VolumeSet volumeSet, VolumeChoosingPolicy volumeChoosingPolicy, ContainerMetrics metrics, IncrementalReportSender<Container> icrSender, ContainerChecksumTreeManager checksumManager) {
        switch (containerType) {
            case KeyValueContainer: {
                return new KeyValueHandler(config, datanodeId, contSet, volumeSet, volumeChoosingPolicy, metrics, icrSender, Clock.systemUTC(), checksumManager);
            }
        }
        throw new IllegalArgumentException("Handler for ContainerType: " + containerType + "doesn't exist.");
    }

    public abstract StateMachine.DataChannel getStreamDataChannel(Container var1, ContainerProtos.ContainerCommandRequestProto var2) throws StorageContainerException;

    @VisibleForTesting
    public String getDatanodeId() {
        return this.datanodeId;
    }

    protected void sendICR(Container container) throws StorageContainerException {
        if (container.getContainerState() == ContainerProtos.ContainerDataProto.State.RECOVERING) {
            return;
        }
        this.icrSender.send(container);
    }

    protected void sendDeferredICR(Container container) throws StorageContainerException {
        if (container.getContainerState() == ContainerProtos.ContainerDataProto.State.RECOVERING) {
            return;
        }
        this.icrSender.sendDeferred(container);
    }

    public abstract ContainerProtos.ContainerCommandResponseProto handle(ContainerProtos.ContainerCommandRequestProto var1, Container var2, DispatcherContext var3);

    public abstract Container importContainer(ContainerData var1, InputStream var2, TarContainerPacker var3) throws IOException;

    public abstract void exportContainer(Container var1, OutputStream var2, TarContainerPacker var3) throws IOException;

    public abstract void stop();

    public abstract void markContainerForClose(Container var1) throws IOException;

    public abstract void updateContainerChecksum(Container var1, ContainerMerkleTreeWriter var2) throws IOException;

    public abstract void markContainerUnhealthy(Container var1, ScanResult var2) throws IOException;

    public abstract void quasiCloseContainer(Container var1, String var2) throws IOException;

    public abstract void closeContainer(Container var1) throws IOException;

    public abstract void deleteContainer(Container var1, boolean var2) throws IOException;

    public abstract void reconcileContainer(DNContainerOperationClient var1, Container<?> var2, Collection<DatanodeDetails> var3) throws IOException;

    public abstract void deleteBlock(Container var1, BlockData var2) throws IOException;

    public abstract void deleteUnreferenced(Container var1, long var2) throws IOException;

    public abstract void addFinalizedBlock(Container var1, long var2);

    public abstract boolean isFinalizedBlockExist(Container var1, long var2);

    public void setClusterID(String clusterID) {
        this.clusterId = clusterID;
    }
}

