/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.shaded.org.bouncycastle.cert.crmf;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.ozone.shaded.org.bouncycastle.asn1.cmp.PBMParameter;
import org.apache.ozone.shaded.org.bouncycastle.asn1.crmf.PKMACValue;
import org.apache.ozone.shaded.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.apache.ozone.shaded.org.bouncycastle.cert.crmf.CRMFException;
import org.apache.ozone.shaded.org.bouncycastle.cert.crmf.PKMACBuilder;
import org.apache.ozone.shaded.org.bouncycastle.operator.MacCalculator;
import org.apache.ozone.shaded.org.bouncycastle.util.Arrays;

class PKMACValueVerifier {
    private final PKMACBuilder builder;

    public PKMACValueVerifier(PKMACBuilder pKMACBuilder) {
        this.builder = pKMACBuilder;
    }

    public boolean isValid(PKMACValue pKMACValue, char[] cArray, SubjectPublicKeyInfo subjectPublicKeyInfo) throws CRMFException {
        this.builder.setParameters(PBMParameter.getInstance(pKMACValue.getAlgId().getParameters()));
        MacCalculator macCalculator = this.builder.build(cArray);
        OutputStream outputStream2 = macCalculator.getOutputStream();
        try {
            outputStream2.write(subjectPublicKeyInfo.getEncoded("DER"));
            outputStream2.close();
        }
        catch (IOException iOException) {
            throw new CRMFException("exception encoding mac input: " + iOException.getMessage(), iOException);
        }
        return Arrays.constantTimeAreEqual(macCalculator.getMac(), pKMACValue.getValue().getOctets());
    }
}

