/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.shaded.org.bouncycastle.cert.crmf;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.ozone.shaded.org.bouncycastle.asn1.DERBitString;
import org.apache.ozone.shaded.org.bouncycastle.asn1.crmf.PKMACValue;
import org.apache.ozone.shaded.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.apache.ozone.shaded.org.bouncycastle.cert.crmf.CRMFException;
import org.apache.ozone.shaded.org.bouncycastle.cert.crmf.PKMACBuilder;
import org.apache.ozone.shaded.org.bouncycastle.operator.MacCalculator;

abstract class PKMACValueGenerator {
    private PKMACValueGenerator() {
    }

    public static PKMACValue generate(PKMACBuilder pKMACBuilder, char[] cArray, SubjectPublicKeyInfo subjectPublicKeyInfo) throws CRMFException {
        MacCalculator macCalculator = pKMACBuilder.build(cArray);
        OutputStream outputStream2 = macCalculator.getOutputStream();
        try {
            outputStream2.write(subjectPublicKeyInfo.getEncoded("DER"));
            outputStream2.close();
        }
        catch (IOException iOException) {
            throw new CRMFException("exception encoding mac input: " + iOException.getMessage(), iOException);
        }
        return new PKMACValue(macCalculator.getAlgorithmIdentifier(), new DERBitString(macCalculator.getMac()));
    }
}

