/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.shaded.org.bouncycastle.asn1.x509;

import java.io.IOException;
import org.apache.ozone.shaded.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.apache.ozone.shaded.org.bouncycastle.asn1.ASN1Primitive;
import org.apache.ozone.shaded.org.bouncycastle.asn1.DERGeneralizedTime;
import org.apache.ozone.shaded.org.bouncycastle.asn1.DERIA5String;
import org.apache.ozone.shaded.org.bouncycastle.asn1.DERPrintableString;
import org.apache.ozone.shaded.org.bouncycastle.asn1.DERUTF8String;
import org.apache.ozone.shaded.org.bouncycastle.asn1.x500.style.BCStyle;
import org.apache.ozone.shaded.org.bouncycastle.asn1.x509.X509NameEntryConverter;

public class X509DefaultEntryConverter
extends X509NameEntryConverter {
    @Override
    public ASN1Primitive getConvertedValue(ASN1ObjectIdentifier aSN1ObjectIdentifier, String string) {
        if (string.length() != 0 && string.charAt(0) == '#') {
            try {
                return this.convertHexEncoded(string, 1);
            }
            catch (IOException iOException) {
                throw new RuntimeException("can't recode value for oid " + aSN1ObjectIdentifier.getId());
            }
        }
        if (string.length() != 0 && string.charAt(0) == '\\') {
            string = string.substring(1);
        }
        if (aSN1ObjectIdentifier.equals(BCStyle.EmailAddress) || aSN1ObjectIdentifier.equals(BCStyle.DC)) {
            return new DERIA5String(string);
        }
        if (aSN1ObjectIdentifier.equals(BCStyle.DATE_OF_BIRTH)) {
            return new DERGeneralizedTime(string);
        }
        if (aSN1ObjectIdentifier.equals(BCStyle.C) || aSN1ObjectIdentifier.equals(BCStyle.SERIALNUMBER) || aSN1ObjectIdentifier.equals(BCStyle.DN_QUALIFIER) || aSN1ObjectIdentifier.equals(BCStyle.TELEPHONE_NUMBER)) {
            return new DERPrintableString(string);
        }
        return new DERUTF8String(string);
    }
}

