/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.netty.handler.codec.http2;

import java.util.List;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.netty.buffer.ByteBuf;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.netty.buffer.ByteBufUtil;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.netty.buffer.Unpooled;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.netty.channel.ChannelHandler;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.netty.channel.ChannelHandlerContext;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.netty.handler.codec.ByteToMessageDecoder;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.netty.handler.codec.http.HttpServerCodec;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.netty.handler.codec.http.HttpServerUpgradeHandler;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.netty.handler.codec.http2.Http2CodecUtil;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.netty.util.internal.ObjectUtil;

public final class CleartextHttp2ServerUpgradeHandler
extends ByteToMessageDecoder {
    private static final ByteBuf CONNECTION_PREFACE = Unpooled.unreleasableBuffer(Http2CodecUtil.connectionPrefaceBuf()).asReadOnly();
    private final HttpServerCodec httpServerCodec;
    private final HttpServerUpgradeHandler httpServerUpgradeHandler;
    private final ChannelHandler http2ServerHandler;

    public CleartextHttp2ServerUpgradeHandler(HttpServerCodec httpServerCodec, HttpServerUpgradeHandler httpServerUpgradeHandler, ChannelHandler http2ServerHandler) {
        this.httpServerCodec = ObjectUtil.checkNotNull(httpServerCodec, "httpServerCodec");
        this.httpServerUpgradeHandler = ObjectUtil.checkNotNull(httpServerUpgradeHandler, "httpServerUpgradeHandler");
        this.http2ServerHandler = ObjectUtil.checkNotNull(http2ServerHandler, "http2ServerHandler");
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        ctx.pipeline().addAfter(ctx.name(), null, this.httpServerUpgradeHandler).addAfter(ctx.name(), null, this.httpServerCodec);
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        int prefaceLength = CONNECTION_PREFACE.readableBytes();
        int bytesRead = Math.min(in.readableBytes(), prefaceLength);
        if (!ByteBufUtil.equals(CONNECTION_PREFACE, CONNECTION_PREFACE.readerIndex(), in, in.readerIndex(), bytesRead)) {
            ctx.pipeline().remove(this);
        } else if (bytesRead == prefaceLength) {
            ctx.pipeline().remove(this.httpServerCodec).remove(this.httpServerUpgradeHandler);
            ctx.pipeline().addAfter(ctx.name(), null, this.http2ServerHandler);
            ctx.pipeline().remove(this);
            ctx.fireUserEventTriggered(PriorKnowledgeUpgradeEvent.INSTANCE);
        }
    }

    public static final class PriorKnowledgeUpgradeEvent {
        private static final PriorKnowledgeUpgradeEvent INSTANCE = new PriorKnowledgeUpgradeEvent();

        private PriorKnowledgeUpgradeEvent() {
        }
    }
}

