/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.shaded.org.apache.ratis.grpc;

import java.io.IOException;
import java.security.PrivateKey;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.TrustManager;
import org.apache.ozone.shaded.org.apache.ratis.protocol.exceptions.ServerNotReadyException;
import org.apache.ozone.shaded.org.apache.ratis.protocol.exceptions.TimeoutIOException;
import org.apache.ozone.shaded.org.apache.ratis.security.TlsConf;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.grpc.ManagedChannel;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.grpc.Metadata;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.grpc.Status;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.grpc.StatusRuntimeException;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.grpc.stub.StreamObserver;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.netty.handler.ssl.SslContextBuilder;
import org.apache.ozone.shaded.org.apache.ratis.util.IOUtils;
import org.apache.ozone.shaded.org.apache.ratis.util.JavaUtils;
import org.apache.ozone.shaded.org.apache.ratis.util.LogUtils;
import org.apache.ozone.shaded.org.apache.ratis.util.ReflectionUtils;
import org.apache.ozone.shaded.org.apache.ratis.util.function.CheckedSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface GrpcUtil {
    public static final Logger LOG = LoggerFactory.getLogger(GrpcUtil.class);
    public static final Metadata.Key<String> EXCEPTION_TYPE_KEY = Metadata.Key.of("exception-type", Metadata.ASCII_STRING_MARSHALLER);
    public static final Metadata.Key<byte[]> EXCEPTION_OBJECT_KEY = Metadata.Key.of("exception-object-bin", Metadata.BINARY_BYTE_MARSHALLER);
    public static final Metadata.Key<String> CALL_ID = Metadata.Key.of("call-id", Metadata.ASCII_STRING_MARSHALLER);
    public static final Metadata.Key<String> HEARTBEAT = Metadata.Key.of("heartbeat", Metadata.ASCII_STRING_MARSHALLER);

    public static StatusRuntimeException wrapException(Throwable t2) {
        return GrpcUtil.wrapException(t2, -1L);
    }

    public static StatusRuntimeException wrapException(Throwable t2, long callId) {
        t2 = JavaUtils.unwrapCompletionException(t2);
        Metadata trailers = new StatusRuntimeExceptionMetadataBuilder(t2).addCallId(callId).build();
        return GrpcUtil.wrapException(t2, trailers);
    }

    public static StatusRuntimeException wrapException(Throwable t2, long callId, boolean isHeartbeat) {
        t2 = JavaUtils.unwrapCompletionException(t2);
        Metadata trailers = new StatusRuntimeExceptionMetadataBuilder(t2).addCallId(callId).addIsHeartbeat(isHeartbeat).build();
        return GrpcUtil.wrapException(t2, trailers);
    }

    public static StatusRuntimeException wrapException(Throwable t2, Metadata trailers) {
        return new StatusRuntimeException(Status.INTERNAL.withCause(t2).withDescription(t2.getMessage()), trailers);
    }

    public static Throwable unwrapThrowable(Throwable t2) {
        Throwable unwrapped;
        if (t2 instanceof StatusRuntimeException && (unwrapped = GrpcUtil.tryUnwrapThrowable((StatusRuntimeException)t2)) != null) {
            return unwrapped;
        }
        return t2;
    }

    public static IOException unwrapException(StatusRuntimeException se) {
        Throwable t2 = GrpcUtil.tryUnwrapThrowable(se);
        return t2 instanceof IOException ? (IOException)t2 : new IOException(t2 != null ? t2 : se);
    }

    public static Throwable tryUnwrapThrowable(StatusRuntimeException se) {
        String className;
        Status status = se.getStatus();
        if (status != null && status.getCode() == Status.Code.DEADLINE_EXCEEDED) {
            return new TimeoutIOException(status.getDescription(), se);
        }
        Metadata trailers = se.getTrailers();
        if (trailers == null) {
            return null;
        }
        byte[] bytes = trailers.get(EXCEPTION_OBJECT_KEY);
        if (bytes != null) {
            try {
                return IOUtils.bytes2Object(bytes, Throwable.class);
            }
            catch (Exception e) {
                se.addSuppressed(e);
            }
        }
        if (status != null && (className = trailers.get(EXCEPTION_TYPE_KEY)) != null) {
            try {
                Class<Throwable> clazz = Class.forName(className).asSubclass(Throwable.class);
                Throwable unwrapped = ReflectionUtils.instantiateException(clazz, status.getDescription());
                return unwrapped.initCause(se);
            }
            catch (Throwable e) {
                se.addSuppressed(e);
                return new IOException(se);
            }
        }
        return null;
    }

    public static long getCallId(Throwable t2) {
        if (t2 instanceof StatusRuntimeException) {
            Metadata trailers = ((StatusRuntimeException)t2).getTrailers();
            String callId = trailers.get(CALL_ID);
            return callId != null ? (long)Integer.parseInt(callId) : -1L;
        }
        return -1L;
    }

    public static boolean isHeartbeat(Throwable t2) {
        if (t2 instanceof StatusRuntimeException) {
            Metadata trailers = ((StatusRuntimeException)t2).getTrailers();
            String isHeartbeat = trailers != null ? trailers.get(HEARTBEAT) : null;
            return isHeartbeat != null && Boolean.valueOf(isHeartbeat) != false;
        }
        return false;
    }

    public static IOException unwrapIOException(Throwable t2) {
        IOException e = t2 instanceof StatusRuntimeException ? GrpcUtil.unwrapException((StatusRuntimeException)t2) : IOUtils.asIOException(t2);
        return e;
    }

    public static <REPLY, REPLY_PROTO> void asyncCall(StreamObserver<REPLY_PROTO> responseObserver, CheckedSupplier<CompletableFuture<REPLY>, IOException> supplier, Function<REPLY, REPLY_PROTO> toProto, Consumer<Throwable> warning) {
        try {
            supplier.get().whenComplete((reply, exception) -> {
                if (exception != null) {
                    warning.accept((Throwable)exception);
                    responseObserver.onError(GrpcUtil.wrapException(exception));
                } else {
                    responseObserver.onNext(toProto.apply(reply));
                    responseObserver.onCompleted();
                }
            });
        }
        catch (Exception e) {
            warning.accept(e);
            responseObserver.onError(GrpcUtil.wrapException(e));
        }
    }

    public static void warn(Logger log, Supplier<String> message, Throwable t2) {
        LogUtils.warn(log, message, GrpcUtil.unwrapThrowable(t2), StatusRuntimeException.class, ServerNotReadyException.class);
    }

    public static void shutdownManagedChannel(ManagedChannel managedChannel) {
        if (!managedChannel.isShutdown()) {
            try {
                managedChannel.shutdown();
                if (!managedChannel.awaitTermination(3L, TimeUnit.SECONDS)) {
                    LOG.warn("Timed out gracefully shutting down connection: {}. ", (Object)managedChannel);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                LOG.error("Unexpected exception while waiting for channel termination", (Throwable)e);
            }
        }
        if (!managedChannel.isTerminated()) {
            try {
                managedChannel.shutdownNow();
                if (!managedChannel.awaitTermination(2L, TimeUnit.SECONDS)) {
                    LOG.warn("Timed out forcefully shutting down connection: {}. ", (Object)managedChannel);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                LOG.error("Unexpected exception while waiting for channel termination", (Throwable)e);
            }
        }
    }

    public static SslContextBuilder initSslContextBuilderForServer(TlsConf.KeyManagerConf keyManagerConfig) {
        KeyManager keyManager = keyManagerConfig.getKeyManager();
        if (keyManager != null) {
            return SslContextBuilder.forServer(keyManager);
        }
        TlsConf.PrivateKeyConf privateKey = keyManagerConfig.getPrivateKey();
        TlsConf.CertificatesConf certificates = keyManagerConfig.getKeyCertificates();
        if (keyManagerConfig.isFileBased()) {
            return SslContextBuilder.forServer(certificates.getFile(), privateKey.getFile());
        }
        return SslContextBuilder.forServer((PrivateKey)privateKey.get(), (Iterable)certificates.get());
    }

    public static void setTrustManager(SslContextBuilder b, TlsConf.TrustManagerConf trustManagerConfig) {
        if (trustManagerConfig == null) {
            return;
        }
        TrustManager trustManager = trustManagerConfig.getTrustManager();
        if (trustManager != null) {
            b.trustManager(trustManager);
            return;
        }
        TlsConf.CertificatesConf certificates = trustManagerConfig.getTrustCertificates();
        if (certificates.isFileBased()) {
            b.trustManager(certificates.getFile());
        } else {
            b.trustManager((Iterable)certificates.get());
        }
    }

    public static void setKeyManager(SslContextBuilder b, TlsConf.KeyManagerConf keyManagerConfig) {
        if (keyManagerConfig == null) {
            return;
        }
        KeyManager keyManager = keyManagerConfig.getKeyManager();
        if (keyManager != null) {
            b.keyManager(keyManager);
            return;
        }
        TlsConf.PrivateKeyConf privateKey = keyManagerConfig.getPrivateKey();
        TlsConf.CertificatesConf certificates = keyManagerConfig.getKeyCertificates();
        if (keyManagerConfig.isFileBased()) {
            b.keyManager(certificates.getFile(), privateKey.getFile());
        } else {
            b.keyManager((PrivateKey)privateKey.get(), (Iterable)certificates.get());
        }
    }

    public static class StatusRuntimeExceptionMetadataBuilder {
        private Metadata trailers = new Metadata();

        StatusRuntimeExceptionMetadataBuilder(Throwable t2) {
            this.trailers.put(EXCEPTION_TYPE_KEY, t2.getClass().getCanonicalName());
            this.trailers.put(EXCEPTION_OBJECT_KEY, IOUtils.object2Bytes(t2));
        }

        StatusRuntimeExceptionMetadataBuilder addCallId(long callId) {
            if (callId > 0L) {
                this.trailers.put(CALL_ID, String.valueOf(callId));
            }
            return this;
        }

        StatusRuntimeExceptionMetadataBuilder addIsHeartbeat(boolean isHeartbeat) {
            this.trailers.put(HEARTBEAT, String.valueOf(isHeartbeat));
            return this;
        }

        Metadata build() {
            return this.trailers;
        }
    }
}

