/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.shaded.okhttp3.internal;

import org.apache.ozone.shaded.kotlin.Metadata;
import org.apache.ozone.shaded.kotlin.collections.ArraysKt;
import org.apache.ozone.shaded.kotlin.jvm.internal.Intrinsics;
import org.apache.ozone.shaded.kotlin.ranges.RangesKt;
import org.apache.ozone.shaded.kotlin.text.Regex;
import org.apache.ozone.shaded.kotlin.text.StringsKt;
import org.apache.ozone.shaded.okhttp3.internal._NormalizeJvmKt;
import org.apache.ozone.shaded.okhttp3.internal._UtilCommonKt;
import org.apache.ozone.shaded.okhttp3.internal.idn.IdnaMappingTableInstanceKt;
import org.apache.ozone.shaded.okhttp3.internal.idn.Punycode;
import org.apache.ozone.shaded.okio.Buffer;
import org.apache.ozone.shaded.org.jetbrains.annotations.NotNull;
import org.apache.ozone.shaded.org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\f\u001a\n\u0010\u0002\u001a\u00020\u0003*\u00020\u0004\u001a\f\u0010\u0005\u001a\u00020\u0003*\u00020\u0004H\u0000\u001a\f\u0010\u0006\u001a\u00020\u0003*\u00020\u0004H\u0000\u001a\"\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0000\u001a0\u0010\r\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u000bH\u0000\u001a\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\bH\u0000\u001a\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\bH\u0000\u001a\u0010\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\bH\u0002\u001a\u0010\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\bH\u0000\u001a\u000e\u0010\u0014\u001a\u0004\u0018\u00010\u0004*\u00020\u0004H\u0000\u001a\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0016\u001a\u00020\u0004H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"VERIFY_AS_IP_ADDRESS", "Lorg/apache/ozone/shaded/kotlin/text/Regex;", "canParseAsIpAddress", "", "", "containsInvalidLabelLengths", "containsInvalidHostnameAsciiCodes", "decodeIpv6", "", "input", "pos", "", "limit", "decodeIpv4Suffix", "address", "addressOffset", "inet6AddressToAscii", "canonicalizeInetAddress", "isMappedIpv4Address", "inet4AddressToAscii", "toCanonicalHost", "idnToAscii", "host", "okhttp"})
public final class _HostnamesCommonKt {
    @NotNull
    private static final Regex VERIFY_AS_IP_ADDRESS = new Regex("([0-9a-fA-F]*:[0-9a-fA-F:.]*)|([\\d.]+)");

    public static final boolean canParseAsIpAddress(@NotNull String $this$canParseAsIpAddress) {
        Intrinsics.checkNotNullParameter($this$canParseAsIpAddress, "<this>");
        return VERIFY_AS_IP_ADDRESS.matches($this$canParseAsIpAddress);
    }

    public static final boolean containsInvalidLabelLengths(@NotNull String $this$containsInvalidLabelLengths) {
        Intrinsics.checkNotNullParameter($this$containsInvalidLabelLengths, "<this>");
        int n = $this$containsInvalidLabelLengths.length();
        if (!(1 <= n ? n < 254 : false)) {
            return true;
        }
        int labelStart = 0;
        while (true) {
            int dot;
            int labelLength;
            int n2 = labelLength = (dot = StringsKt.indexOf$default((CharSequence)$this$containsInvalidLabelLengths, '.', labelStart, false, 4, null)) == -1 ? $this$containsInvalidLabelLengths.length() - labelStart : dot - labelStart;
            if (!(1 <= labelLength ? labelLength < 64 : false)) {
                return true;
            }
            if (dot == -1 || dot == $this$containsInvalidLabelLengths.length() - 1) break;
            labelStart = dot + 1;
        }
        return false;
    }

    public static final boolean containsInvalidHostnameAsciiCodes(@NotNull String $this$containsInvalidHostnameAsciiCodes) {
        Intrinsics.checkNotNullParameter($this$containsInvalidHostnameAsciiCodes, "<this>");
        int n = $this$containsInvalidHostnameAsciiCodes.length();
        for (int i = 0; i < n; ++i) {
            char c = $this$containsInvalidHostnameAsciiCodes.charAt(i);
            if (Intrinsics.compare(c, 31) <= 0 || Intrinsics.compare(c, 127) >= 0) {
                return true;
            }
            if (StringsKt.indexOf$default((CharSequence)" #%/:?@[\\]", c, 0, false, 6, null) == -1) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static final byte[] decodeIpv6(@NotNull String input, int pos, int limit) {
        Intrinsics.checkNotNullParameter(input, "input");
        byte[] address = new byte[16];
        int b = 0;
        int compress = -1;
        int groupOffset = -1;
        int i = pos;
        while (i < limit) {
            int hexDigit;
            if (b == address.length) {
                return null;
            }
            if (i + 2 <= limit && StringsKt.startsWith$default(input, "::", i, false, 4, null)) {
                if (compress != -1) {
                    return null;
                }
                compress = b += 2;
                if ((i += 2) == limit) {
                    break;
                }
            } else if (b != 0 && !StringsKt.startsWith$default(input, ":", i, false, 4, null)) {
                if (StringsKt.startsWith$default(input, ".", i, false, 4, null)) {
                    if (!_HostnamesCommonKt.decodeIpv4Suffix(input, groupOffset, limit, address, b - 2)) {
                        return null;
                    }
                    b += 2;
                    break;
                }
                return null;
            }
            int value = 0;
            groupOffset = ++i;
            while (i < limit && (hexDigit = _UtilCommonKt.parseHexDigit(input.charAt(i))) != -1) {
                value = (value << 4) + hexDigit;
                ++i;
            }
            int groupLength = i - groupOffset;
            if (groupLength == 0 || groupLength > 4) {
                return null;
            }
            address[b++] = (byte)(value >>> 8 & 0xFF);
            address[b++] = (byte)(value & 0xFF);
        }
        if (b != address.length) {
            if (compress == -1) {
                return null;
            }
            ArraysKt.copyInto(address, address, address.length - (b - compress), compress, b);
            ArraysKt.fill(address, (byte)0, compress, compress + (address.length - b));
        }
        return address;
    }

    public static final boolean decodeIpv4Suffix(@NotNull String input, int pos, int limit, @NotNull byte[] address, int addressOffset) {
        Intrinsics.checkNotNullParameter(input, "input");
        Intrinsics.checkNotNullParameter(address, "address");
        int b = addressOffset;
        int i = pos;
        while (i < limit) {
            char c;
            if (b == address.length) {
                return false;
            }
            if (b != addressOffset && input.charAt(i) != '.') {
                return false;
            }
            int value = 0;
            int groupOffset = ++i;
            while (i < limit && Intrinsics.compare(c = input.charAt(i), 48) >= 0 && Intrinsics.compare(c, 57) <= 0) {
                if (value == 0 && groupOffset != i) {
                    return false;
                }
                if ((value = value * 10 + c - 48) > 255) {
                    return false;
                }
                ++i;
            }
            int groupLength = i - groupOffset;
            if (groupLength == 0) {
                return false;
            }
            address[b++] = (byte)value;
        }
        return b == addressOffset + 4;
    }

    @NotNull
    public static final String inet6AddressToAscii(@NotNull byte[] address) {
        int i;
        Intrinsics.checkNotNullParameter(address, "address");
        int longestRunOffset = 0;
        longestRunOffset = -1;
        int longestRunLength = 0;
        boolean bl = false;
        for (i = 0; i < address.length; i += 2) {
            int currentRunOffset = i;
            while (i < 16 && address[i] == 0 && address[i + 1] == 0) {
                i += 2;
            }
            int currentRunLength = i - currentRunOffset;
            if (currentRunLength <= longestRunLength || currentRunLength < 4) continue;
            longestRunOffset = currentRunOffset;
            longestRunLength = currentRunLength;
        }
        Buffer result2 = new Buffer();
        i = 0;
        while (i < address.length) {
            if (i == longestRunOffset) {
                result2.writeByte(58);
                if ((i += longestRunLength) != 16) continue;
                result2.writeByte(58);
                continue;
            }
            if (i > 0) {
                result2.writeByte(58);
            }
            int group = _UtilCommonKt.and(address[i], 255) << 8 | _UtilCommonKt.and(address[i + 1], 255);
            result2.writeHexadecimalUnsignedLong(group);
            i += 2;
        }
        return result2.readUtf8();
    }

    @NotNull
    public static final byte[] canonicalizeInetAddress(@NotNull byte[] address) {
        Intrinsics.checkNotNullParameter(address, "address");
        return _HostnamesCommonKt.isMappedIpv4Address(address) ? ArraysKt.sliceArray(address, RangesKt.until(12, 16)) : address;
    }

    private static final boolean isMappedIpv4Address(byte[] address) {
        if (address.length != 16) {
            return false;
        }
        for (int i = 0; i < 10; ++i) {
            if (address[i] == 0) continue;
            return false;
        }
        if (address[10] != -1) {
            return false;
        }
        return address[11] == -1;
    }

    @NotNull
    public static final String inet4AddressToAscii(@NotNull byte[] address) {
        Intrinsics.checkNotNullParameter(address, "address");
        if (!(address.length == 4)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return new Buffer().writeDecimalLong(_UtilCommonKt.and(address[0], 255)).writeByte(46).writeDecimalLong(_UtilCommonKt.and(address[1], 255)).writeByte(46).writeDecimalLong(_UtilCommonKt.and(address[2], 255)).writeByte(46).writeDecimalLong(_UtilCommonKt.and(address[3], 255)).readUtf8();
    }

    @Nullable
    public static final String toCanonicalHost(@NotNull String $this$toCanonicalHost) {
        Intrinsics.checkNotNullParameter($this$toCanonicalHost, "<this>");
        String host = $this$toCanonicalHost;
        if (StringsKt.contains$default((CharSequence)host, ":", false, 2, null)) {
            byte[] byArray = StringsKt.startsWith$default(host, "[", false, 2, null) && StringsKt.endsWith$default(host, "]", false, 2, null) ? _HostnamesCommonKt.decodeIpv6(host, 1, host.length() - 1) : _HostnamesCommonKt.decodeIpv6(host, 0, host.length());
            if (byArray == null) {
                return null;
            }
            byte[] inetAddressByteArray = byArray;
            byte[] address = _HostnamesCommonKt.canonicalizeInetAddress(inetAddressByteArray);
            if (address.length == 16) {
                return _HostnamesCommonKt.inet6AddressToAscii(address);
            }
            if (address.length == 4) {
                return _HostnamesCommonKt.inet4AddressToAscii(address);
            }
            throw new AssertionError((Object)("Invalid IPv6 address: '" + host + '\''));
        }
        String string = _HostnamesCommonKt.idnToAscii(host);
        if (string == null) {
            return null;
        }
        String result2 = string;
        if (((CharSequence)result2).length() == 0) {
            return null;
        }
        if (_HostnamesCommonKt.containsInvalidHostnameAsciiCodes(result2)) {
            return null;
        }
        if (_HostnamesCommonKt.containsInvalidLabelLengths(result2)) {
            return null;
        }
        return result2;
    }

    @Nullable
    public static final String idnToAscii(@NotNull String host) {
        Intrinsics.checkNotNullParameter(host, "host");
        Buffer bufferA = new Buffer().writeUtf8(host);
        Buffer bufferB = new Buffer();
        while (!bufferA.exhausted()) {
            int codePoint = bufferA.readUtf8CodePoint();
            if (IdnaMappingTableInstanceKt.getIDNA_MAPPING_TABLE().map(codePoint, bufferB)) continue;
            return null;
        }
        String normalized = _NormalizeJvmKt.normalizeNfc(bufferB.readUtf8());
        bufferA.writeUtf8(normalized);
        String string = Punycode.INSTANCE.decode(bufferA.readUtf8());
        if (string == null) {
            return null;
        }
        String decoded = string;
        if (!Intrinsics.areEqual(decoded, _NormalizeJvmKt.normalizeNfc(decoded))) {
            return null;
        }
        return Punycode.INSTANCE.encode(decoded);
    }
}

