/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.internal.state;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.apache.ozone.shaded.io.opentelemetry.api.common.Attributes;
import org.apache.ozone.shaded.io.opentelemetry.api.metrics.ObservableDoubleMeasurement;
import org.apache.ozone.shaded.io.opentelemetry.api.metrics.ObservableLongMeasurement;
import org.apache.ozone.shaded.io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import org.apache.ozone.shaded.io.opentelemetry.sdk.internal.ThrottlingLogger;
import org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.internal.export.RegisteredReader;
import org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.internal.state.AsynchronousMetricStorage;

public final class SdkObservableMeasurement
implements ObservableLongMeasurement,
ObservableDoubleMeasurement {
    private static final Logger logger = Logger.getLogger(SdkObservableMeasurement.class.getName());
    private final ThrottlingLogger throttlingLogger = new ThrottlingLogger(logger);
    private final InstrumentationScopeInfo instrumentationScopeInfo;
    private final InstrumentDescriptor instrumentDescriptor;
    private final List<AsynchronousMetricStorage<?, ?>> storages;
    @Nullable
    private volatile RegisteredReader activeReader;

    private SdkObservableMeasurement(InstrumentationScopeInfo instrumentationScopeInfo, InstrumentDescriptor instrumentDescriptor, List<AsynchronousMetricStorage<?, ?>> storages) {
        this.instrumentationScopeInfo = instrumentationScopeInfo;
        this.instrumentDescriptor = instrumentDescriptor;
        this.storages = storages;
    }

    public static SdkObservableMeasurement create(InstrumentationScopeInfo instrumentationScopeInfo, InstrumentDescriptor instrumentDescriptor, List<AsynchronousMetricStorage<?, ?>> storages) {
        return new SdkObservableMeasurement(instrumentationScopeInfo, instrumentDescriptor, storages);
    }

    public InstrumentationScopeInfo getInstrumentationScopeInfo() {
        return this.instrumentationScopeInfo;
    }

    public void setActiveReader(RegisteredReader registeredReader, long startEpochNanos, long epochNanos) {
        this.activeReader = registeredReader;
        for (AsynchronousMetricStorage<?, ?> storage : this.storages) {
            if (!storage.getRegisteredReader().equals(this.activeReader)) continue;
            storage.setEpochInformation(startEpochNanos, epochNanos);
        }
    }

    public void unsetActiveReader() {
        this.activeReader = null;
    }

    InstrumentDescriptor getInstrumentDescriptor() {
        return this.instrumentDescriptor;
    }

    List<AsynchronousMetricStorage<?, ?>> getStorages() {
        return this.storages;
    }

    @Override
    public void record(long value) {
        this.record(value, Attributes.empty());
    }

    @Override
    public void record(long value, Attributes attributes) {
        RegisteredReader activeReader = this.activeReader;
        if (activeReader == null) {
            this.logNoActiveReader();
            return;
        }
        for (AsynchronousMetricStorage<?, ?> storage : this.storages) {
            if (!storage.getRegisteredReader().equals(activeReader)) continue;
            storage.record(attributes, value);
        }
    }

    @Override
    public void record(double value) {
        this.record(value, Attributes.empty());
    }

    @Override
    public void record(double value, Attributes attributes) {
        RegisteredReader activeReader = this.activeReader;
        if (activeReader == null) {
            this.logNoActiveReader();
            return;
        }
        if (Double.isNaN(value)) {
            logger.log(Level.FINE, "Instrument " + this.instrumentDescriptor.getName() + " has recorded measurement Not-a-Number (NaN) value with attributes " + attributes + ". Dropping measurement.");
            return;
        }
        for (AsynchronousMetricStorage<?, ?> storage : this.storages) {
            if (!storage.getRegisteredReader().equals(activeReader)) continue;
            storage.record(attributes, value);
        }
    }

    private void logNoActiveReader() {
        this.throttlingLogger.log(Level.FINE, "Measurement recorded for instrument " + this.instrumentDescriptor.getName() + " outside callback registered to instrument. Dropping measurement.");
    }
}

