/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.export;

import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.ozone.shaded.io.opentelemetry.api.internal.Utils;
import org.apache.ozone.shaded.io.opentelemetry.sdk.internal.DaemonThreadFactory;
import org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.export.MetricExporter;
import org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.export.PeriodicMetricReader;

public final class PeriodicMetricReaderBuilder {
    static final long DEFAULT_SCHEDULE_DELAY_MINUTES = 1L;
    private final MetricExporter metricExporter;
    private long intervalNanos = TimeUnit.MINUTES.toNanos(1L);
    @Nullable
    private ScheduledExecutorService executor;

    PeriodicMetricReaderBuilder(MetricExporter metricExporter) {
        this.metricExporter = metricExporter;
    }

    public PeriodicMetricReaderBuilder setInterval(long interval, TimeUnit unit) {
        Objects.requireNonNull(unit, "unit");
        Utils.checkArgument(interval > 0L, "interval must be positive");
        this.intervalNanos = unit.toNanos(interval);
        return this;
    }

    public PeriodicMetricReaderBuilder setInterval(Duration interval) {
        Objects.requireNonNull(interval, "interval");
        return this.setInterval(interval.toNanos(), TimeUnit.NANOSECONDS);
    }

    public PeriodicMetricReaderBuilder setExecutor(ScheduledExecutorService executor) {
        Objects.requireNonNull(executor, "executor");
        this.executor = executor;
        return this;
    }

    public PeriodicMetricReader build() {
        ScheduledExecutorService executor = this.executor;
        if (executor == null) {
            executor = Executors.newScheduledThreadPool(1, new DaemonThreadFactory("PeriodicMetricReader"));
        }
        return new PeriodicMetricReader(this.metricExporter, this.intervalNanos, executor);
    }
}

