/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.shaded.io.opentelemetry.exporter.internal.otlp;

import java.io.IOException;
import org.apache.ozone.shaded.io.opentelemetry.exporter.internal.marshal.CodedOutputStream;
import org.apache.ozone.shaded.io.opentelemetry.exporter.internal.marshal.MarshalerUtil;
import org.apache.ozone.shaded.io.opentelemetry.exporter.internal.marshal.MarshalerWithSize;
import org.apache.ozone.shaded.io.opentelemetry.exporter.internal.marshal.Serializer;
import org.apache.ozone.shaded.io.opentelemetry.proto.common.v1.internal.AnyValue;

final class StringAnyValueMarshaler
extends MarshalerWithSize {
    private final byte[] valueUtf8;

    private StringAnyValueMarshaler(byte[] valueUtf8) {
        super(StringAnyValueMarshaler.calculateSize(valueUtf8));
        this.valueUtf8 = valueUtf8;
    }

    static MarshalerWithSize create(String value) {
        return new StringAnyValueMarshaler(MarshalerUtil.toBytes(value));
    }

    @Override
    public void writeTo(Serializer output) throws IOException {
        if (this.valueUtf8.length == 0) {
            return;
        }
        output.writeString(AnyValue.STRING_VALUE, this.valueUtf8);
    }

    private static int calculateSize(byte[] valueUtf8) {
        if (valueUtf8.length == 0) {
            return 0;
        }
        return AnyValue.STRING_VALUE.getTagSize() + CodedOutputStream.computeByteArraySizeNoTag(valueUtf8);
    }
}

