/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.shaded.io.opentelemetry.api.trace;

import javax.annotation.concurrent.Immutable;
import org.apache.ozone.shaded.io.opentelemetry.api.internal.ApiUsageLogger;
import org.apache.ozone.shaded.io.opentelemetry.api.internal.OtelEncodingUtils;
import org.apache.ozone.shaded.io.opentelemetry.api.internal.TemporaryBuffers;

@Immutable
public final class SpanId {
    private static final int BYTES_LENGTH = 8;
    private static final int HEX_LENGTH = 16;
    private static final String INVALID = "0000000000000000";

    private SpanId() {
    }

    public static int getLength() {
        return 16;
    }

    public static String getInvalid() {
        return INVALID;
    }

    public static boolean isValid(CharSequence spanId) {
        return spanId != null && spanId.length() == 16 && !INVALID.contentEquals(spanId) && OtelEncodingUtils.isValidBase16String(spanId);
    }

    public static String fromBytes(byte[] spanIdBytes) {
        if (spanIdBytes == null || spanIdBytes.length < 8) {
            ApiUsageLogger.log("spanIdBytes is null or too short");
            return INVALID;
        }
        char[] result2 = TemporaryBuffers.chars(16);
        OtelEncodingUtils.bytesToBase16(spanIdBytes, result2, 8);
        return new String(result2, 0, 16);
    }

    public static String fromLong(long id) {
        if (id == 0L) {
            return SpanId.getInvalid();
        }
        char[] result2 = TemporaryBuffers.chars(16);
        OtelEncodingUtils.longToBase16String(id, result2, 0);
        return new String(result2, 0, 16);
    }
}

