/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.shaded.io.grpc.util;

import org.apache.ozone.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.ozone.shaded.com.google.common.base.Preconditions;
import org.apache.ozone.shaded.io.grpc.Attributes;
import org.apache.ozone.shaded.io.grpc.ConnectivityStateInfo;
import org.apache.ozone.shaded.io.grpc.Internal;
import org.apache.ozone.shaded.io.grpc.LoadBalancer;
import org.apache.ozone.shaded.io.grpc.util.ForwardingLoadBalancerHelper;
import org.apache.ozone.shaded.io.grpc.util.ForwardingSubchannel;

@Internal
public final class HealthProducerHelper
extends ForwardingLoadBalancerHelper {
    private final LoadBalancer.Helper delegate;

    public HealthProducerHelper(LoadBalancer.Helper helper) {
        this.delegate = Preconditions.checkNotNull(helper, "helper");
    }

    @Override
    public LoadBalancer.Subchannel createSubchannel(LoadBalancer.CreateSubchannelArgs args2) {
        boolean alreadyParent;
        LoadBalancer.SubchannelStateListener healthConsumerListener = args2.getOption(LoadBalancer.HEALTH_CONSUMER_LISTENER_ARG_KEY);
        LoadBalancer.Subchannel delegateSubchannel = super.createSubchannel(args2);
        boolean bl = alreadyParent = healthConsumerListener != null && delegateSubchannel.getAttributes().get(LoadBalancer.HAS_HEALTH_PRODUCER_LISTENER_KEY) == null;
        if (!alreadyParent) {
            return delegateSubchannel;
        }
        return new HealthProducerSubchannel(delegateSubchannel, healthConsumerListener);
    }

    @Override
    protected LoadBalancer.Helper delegate() {
        return this.delegate;
    }

    @VisibleForTesting
    static final class HealthProducerSubchannel
    extends ForwardingSubchannel {
        private final LoadBalancer.Subchannel delegate;
        private final LoadBalancer.SubchannelStateListener healthListener;

        HealthProducerSubchannel(LoadBalancer.Subchannel delegate, LoadBalancer.SubchannelStateListener healthListener) {
            this.delegate = Preconditions.checkNotNull(delegate, "delegate");
            this.healthListener = Preconditions.checkNotNull(healthListener, "healthListener");
        }

        @Override
        public LoadBalancer.Subchannel delegate() {
            return this.delegate;
        }

        @Override
        public void start(final LoadBalancer.SubchannelStateListener listener) {
            this.delegate.start(new LoadBalancer.SubchannelStateListener(){

                @Override
                public void onSubchannelState(ConnectivityStateInfo newState) {
                    listener.onSubchannelState(newState);
                    healthListener.onSubchannelState(newState);
                }
            });
        }

        @Override
        public Attributes getAttributes() {
            return super.getAttributes().toBuilder().set(LoadBalancer.HAS_HEALTH_PRODUCER_LISTENER_KEY, Boolean.TRUE).build();
        }
    }
}

