/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.helpers;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.apache.hadoop.hdds.HddsUtils;
import org.apache.hadoop.hdds.utils.db.Codec;
import org.apache.hadoop.hdds.utils.db.CopyObject;
import org.apache.hadoop.hdds.utils.db.DelegatedCodec;
import org.apache.hadoop.hdds.utils.db.Proto2Codec;
import org.apache.hadoop.ozone.audit.Auditable;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.shaded.com.google.protobuf.ByteString;
import org.apache.ozone.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.ozone.shaded.com.google.common.base.Preconditions;
import org.apache.ozone.shaded.org.apache.commons.lang3.StringUtils;

public final class SnapshotInfo
implements Auditable,
CopyObject<SnapshotInfo> {
    private static final Codec<SnapshotInfo> CODEC = new DelegatedCodec<SnapshotInfo, OzoneManagerProtocolProtos.SnapshotInfo>(Proto2Codec.get(OzoneManagerProtocolProtos.SnapshotInfo.getDefaultInstance()), SnapshotInfo::getFromProtobuf, SnapshotInfo::getProtobuf, SnapshotInfo.class);
    private static final String SEPARATOR = "-";
    private static final long INVALID_TIMESTAMP = -1L;
    private static final UUID INITIAL_SNAPSHOT_ID = UUID.randomUUID();
    private final UUID snapshotId;
    private String name;
    private String volumeName;
    private String bucketName;
    private SnapshotStatus snapshotStatus;
    private final long creationTime;
    private long deletionTime;
    private UUID pathPreviousSnapshotId;
    private UUID globalPreviousSnapshotId;
    private String snapshotPath;
    private String checkpointDir;
    private long dbTxSequenceNumber;
    private boolean deepClean;
    private boolean sstFiltered;
    private long referencedSize;
    private long referencedReplicatedSize;
    private long exclusiveSize;
    private long exclusiveReplicatedSize;
    private long exclusiveSizeDeltaFromDirDeepCleaning;
    private long exclusiveReplicatedSizeDeltaFromDirDeepCleaning;
    private boolean deepCleanedDeletedDir;
    private ByteString createTransactionInfo;
    private ByteString lastTransactionInfo;

    private SnapshotInfo(Builder b) {
        this.snapshotId = b.snapshotId;
        this.name = b.name;
        this.volumeName = b.volumeName;
        this.bucketName = b.bucketName;
        this.snapshotStatus = b.snapshotStatus;
        this.creationTime = b.creationTime;
        this.deletionTime = b.deletionTime;
        this.pathPreviousSnapshotId = b.pathPreviousSnapshotId;
        this.globalPreviousSnapshotId = b.globalPreviousSnapshotId;
        this.snapshotPath = b.snapshotPath;
        this.checkpointDir = b.checkpointDir;
        this.dbTxSequenceNumber = b.dbTxSequenceNumber;
        this.deepClean = b.deepClean;
        this.sstFiltered = b.sstFiltered;
        this.referencedSize = b.referencedSize;
        this.referencedReplicatedSize = b.referencedReplicatedSize;
        this.exclusiveSize = b.exclusiveSize;
        this.exclusiveReplicatedSize = b.exclusiveReplicatedSize;
        this.exclusiveSizeDeltaFromDirDeepCleaning = b.exclusiveSizeDeltaFromDirDeepCleaning;
        this.exclusiveReplicatedSizeDeltaFromDirDeepCleaning = b.exclusiveReplicatedSizeDeltaFromDirDeepCleaning;
        this.deepCleanedDeletedDir = b.deepCleanedDeletedDir;
        this.lastTransactionInfo = b.lastTransactionInfo;
        this.createTransactionInfo = b.createTransactionInfo;
    }

    public static Codec<SnapshotInfo> getCodec() {
        return CODEC;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setVolumeName(String volumeName) {
        this.volumeName = volumeName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public void setSnapshotStatus(SnapshotStatus snapshotStatus) {
        this.snapshotStatus = snapshotStatus;
    }

    public void setDeletionTime(long delTime) {
        this.deletionTime = delTime;
    }

    public void setPathPreviousSnapshotId(UUID pathPreviousSnapshotId) {
        this.pathPreviousSnapshotId = pathPreviousSnapshotId;
    }

    public void setGlobalPreviousSnapshotId(UUID globalPreviousSnapshotId) {
        this.globalPreviousSnapshotId = globalPreviousSnapshotId;
    }

    public void setSnapshotPath(String snapshotPath) {
        this.snapshotPath = snapshotPath;
    }

    public void setCheckpointDir(String checkpointDir) {
        this.checkpointDir = checkpointDir;
    }

    public boolean isDeepCleaned() {
        return this.deepClean;
    }

    public void setDeepClean(boolean deepClean) {
        this.deepClean = deepClean;
    }

    public UUID getSnapshotId() {
        return this.snapshotId;
    }

    public String getName() {
        return this.name;
    }

    public String getVolumeName() {
        return this.volumeName;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public SnapshotStatus getSnapshotStatus() {
        return this.snapshotStatus;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getDeletionTime() {
        return this.deletionTime;
    }

    public UUID getPathPreviousSnapshotId() {
        return this.pathPreviousSnapshotId;
    }

    public UUID getGlobalPreviousSnapshotId() {
        return this.globalPreviousSnapshotId;
    }

    public String getSnapshotPath() {
        return this.snapshotPath;
    }

    public String getCheckpointDir() {
        return this.checkpointDir;
    }

    public boolean isSstFiltered() {
        return this.sstFiltered;
    }

    public void setSstFiltered(boolean sstFiltered) {
        this.sstFiltered = sstFiltered;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().setSnapshotId(this.snapshotId).setName(this.name).setVolumeName(this.volumeName).setBucketName(this.bucketName).setSnapshotStatus(this.snapshotStatus).setCreationTime(this.creationTime).setDeletionTime(this.deletionTime).setPathPreviousSnapshotId(this.pathPreviousSnapshotId).setGlobalPreviousSnapshotId(this.globalPreviousSnapshotId).setSnapshotPath(this.snapshotPath).setCheckpointDir(this.checkpointDir).setDbTxSequenceNumber(this.dbTxSequenceNumber).setDeepClean(this.deepClean).setSstFiltered(this.sstFiltered).setReferencedSize(this.referencedSize).setReferencedReplicatedSize(this.referencedReplicatedSize).setExclusiveSize(this.exclusiveSize).setExclusiveReplicatedSize(this.exclusiveReplicatedSize).setExclusiveSizeDeltaFromDirDeepCleaning(this.exclusiveSizeDeltaFromDirDeepCleaning).setExclusiveReplicatedSizeDeltaFromDirDeepCleaning(this.exclusiveReplicatedSizeDeltaFromDirDeepCleaning).setDeepCleanedDeletedDir(this.deepCleanedDeletedDir).setLastTransactionInfo(this.lastTransactionInfo).setCreateTransactionInfo(this.createTransactionInfo);
    }

    public OzoneManagerProtocolProtos.SnapshotInfo getProtobuf() {
        OzoneManagerProtocolProtos.SnapshotInfo.Builder sib = OzoneManagerProtocolProtos.SnapshotInfo.newBuilder().setSnapshotID(HddsUtils.toProtobuf(this.snapshotId)).setName(this.name).setVolumeName(this.volumeName).setBucketName(this.bucketName).setSnapshotStatus(this.snapshotStatus.toProto()).setCreationTime(this.creationTime).setDeletionTime(this.deletionTime).setSstFiltered(this.sstFiltered).setReferencedSize(this.referencedSize).setReferencedReplicatedSize(this.referencedReplicatedSize).setExclusiveSize(this.exclusiveSize).setExclusiveReplicatedSize(this.exclusiveReplicatedSize).setExclusiveSizeDeltaFromDirDeepCleaning(this.exclusiveSizeDeltaFromDirDeepCleaning).setExclusiveReplicatedSizeDeltaFromDirDeepCleaning(this.exclusiveReplicatedSizeDeltaFromDirDeepCleaning).setDeepCleanedDeletedDir(this.deepCleanedDeletedDir);
        if (this.pathPreviousSnapshotId != null) {
            sib.setPathPreviousSnapshotID(HddsUtils.toProtobuf(this.pathPreviousSnapshotId));
        }
        if (this.globalPreviousSnapshotId != null) {
            sib.setGlobalPreviousSnapshotID(HddsUtils.toProtobuf(this.globalPreviousSnapshotId));
        }
        if (this.lastTransactionInfo != null) {
            sib.setLastTransactionInfo(this.lastTransactionInfo);
        }
        if (this.createTransactionInfo != null) {
            sib.setCreateTransactionInfo(this.createTransactionInfo);
        }
        sib.setSnapshotPath(this.snapshotPath).setCheckpointDir(this.checkpointDir).setDbTxSequenceNumber(this.dbTxSequenceNumber).setDeepClean(this.deepClean);
        return sib.build();
    }

    public static SnapshotInfo getFromProtobuf(OzoneManagerProtocolProtos.SnapshotInfo snapshotInfoProto) {
        Builder osib = SnapshotInfo.newBuilder().setSnapshotId(HddsUtils.fromProtobuf(snapshotInfoProto.getSnapshotID())).setName(snapshotInfoProto.getName()).setVolumeName(snapshotInfoProto.getVolumeName()).setBucketName(snapshotInfoProto.getBucketName()).setSnapshotStatus(SnapshotStatus.valueOf(snapshotInfoProto.getSnapshotStatus())).setCreationTime(snapshotInfoProto.getCreationTime()).setDeletionTime(snapshotInfoProto.getDeletionTime());
        if (snapshotInfoProto.hasPathPreviousSnapshotID()) {
            osib.setPathPreviousSnapshotId(HddsUtils.fromProtobuf(snapshotInfoProto.getPathPreviousSnapshotID()));
        }
        if (snapshotInfoProto.hasGlobalPreviousSnapshotID()) {
            osib.setGlobalPreviousSnapshotId(HddsUtils.fromProtobuf(snapshotInfoProto.getGlobalPreviousSnapshotID()));
        }
        if (snapshotInfoProto.hasDeepClean()) {
            osib.setDeepClean(snapshotInfoProto.getDeepClean());
        }
        if (snapshotInfoProto.hasSstFiltered()) {
            osib.setSstFiltered(snapshotInfoProto.getSstFiltered());
        }
        if (snapshotInfoProto.hasReferencedSize()) {
            osib.setReferencedSize(snapshotInfoProto.getReferencedSize());
        }
        if (snapshotInfoProto.hasReferencedReplicatedSize()) {
            osib.setReferencedReplicatedSize(snapshotInfoProto.getReferencedReplicatedSize());
        }
        if (snapshotInfoProto.hasExclusiveSize()) {
            osib.setExclusiveSize(snapshotInfoProto.getExclusiveSize());
        }
        if (snapshotInfoProto.hasExclusiveReplicatedSize()) {
            osib.setExclusiveReplicatedSize(snapshotInfoProto.getExclusiveReplicatedSize());
        }
        if (snapshotInfoProto.hasExclusiveSizeDeltaFromDirDeepCleaning()) {
            osib.setExclusiveSizeDeltaFromDirDeepCleaning(snapshotInfoProto.getExclusiveSizeDeltaFromDirDeepCleaning());
        }
        if (snapshotInfoProto.hasExclusiveReplicatedSizeDeltaFromDirDeepCleaning()) {
            osib.setExclusiveReplicatedSizeDeltaFromDirDeepCleaning(snapshotInfoProto.getExclusiveReplicatedSizeDeltaFromDirDeepCleaning());
        }
        if (snapshotInfoProto.hasDeepCleanedDeletedDir()) {
            osib.setDeepCleanedDeletedDir(snapshotInfoProto.getDeepCleanedDeletedDir());
        }
        if (snapshotInfoProto.hasLastTransactionInfo()) {
            osib.setLastTransactionInfo(snapshotInfoProto.getLastTransactionInfo());
        }
        if (snapshotInfoProto.hasCreateTransactionInfo()) {
            osib.setCreateTransactionInfo(snapshotInfoProto.getCreateTransactionInfo());
        }
        osib.setSnapshotPath(snapshotInfoProto.getSnapshotPath()).setCheckpointDir(snapshotInfoProto.getCheckpointDir()).setDbTxSequenceNumber(snapshotInfoProto.getDbTxSequenceNumber());
        return osib.build();
    }

    @Override
    public Map<String, String> toAuditMap() {
        LinkedHashMap<String, String> auditMap = new LinkedHashMap<String, String>();
        auditMap.put("volume", this.getVolumeName());
        auditMap.put("bucket", this.getBucketName());
        auditMap.put("snapshotName", this.name);
        return auditMap;
    }

    public static String getCheckpointDirName(UUID snapshotId) {
        Objects.requireNonNull(snapshotId, "SnapshotId is needed to create checkpoint directory");
        return SEPARATOR + snapshotId;
    }

    public String getCheckpointDirName() {
        return SnapshotInfo.getCheckpointDirName(this.getSnapshotId());
    }

    public long getDbTxSequenceNumber() {
        return this.dbTxSequenceNumber;
    }

    public void setDbTxSequenceNumber(long dbTxSequenceNumber) {
        this.dbTxSequenceNumber = dbTxSequenceNumber;
    }

    public String getTableKey() {
        return SnapshotInfo.getTableKey(this.volumeName, this.bucketName, this.name);
    }

    public static String getTableKey(String volumeName, String bucketName, String snapshotName) {
        return "/" + volumeName + "/" + bucketName + "/" + snapshotName;
    }

    public void setReferencedSize(long referencedSize) {
        this.referencedSize = referencedSize;
    }

    public long getReferencedSize() {
        return this.referencedSize;
    }

    public void setReferencedReplicatedSize(long referencedReplicatedSize) {
        this.referencedReplicatedSize = referencedReplicatedSize;
    }

    public long getReferencedReplicatedSize() {
        return this.referencedReplicatedSize;
    }

    public void setExclusiveSize(long exclusiveSize) {
        this.exclusiveSize = exclusiveSize;
    }

    public long getExclusiveSize() {
        return this.exclusiveSize;
    }

    public void setExclusiveSizeDeltaFromDirDeepCleaning(long exclusiveSizeDeltaFromDirDeepCleaning) {
        this.exclusiveSizeDeltaFromDirDeepCleaning = exclusiveSizeDeltaFromDirDeepCleaning;
    }

    public long getExclusiveSizeDeltaFromDirDeepCleaning() {
        return this.exclusiveSizeDeltaFromDirDeepCleaning;
    }

    public void setExclusiveReplicatedSize(long exclusiveReplicatedSize) {
        this.exclusiveReplicatedSize = exclusiveReplicatedSize;
    }

    public void setExclusiveReplicatedSizeDeltaFromDirDeepCleaning(long exclusiveReplicatedSizeDeltaFromDirDeepCleaning) {
        this.exclusiveReplicatedSizeDeltaFromDirDeepCleaning = exclusiveReplicatedSizeDeltaFromDirDeepCleaning;
    }

    public long getExclusiveReplicatedSizeDeltaFromDirDeepCleaning() {
        return this.exclusiveReplicatedSizeDeltaFromDirDeepCleaning;
    }

    public long getExclusiveReplicatedSize() {
        return this.exclusiveReplicatedSize;
    }

    public boolean isDeepCleanedDeletedDir() {
        return this.deepCleanedDeletedDir;
    }

    public void setDeepCleanedDeletedDir(boolean deepCleanedDeletedDir) {
        this.deepCleanedDeletedDir = deepCleanedDeletedDir;
    }

    public ByteString getLastTransactionInfo() {
        return this.lastTransactionInfo;
    }

    public ByteString getCreateTransactionInfo() {
        return this.createTransactionInfo;
    }

    public void setCreateTransactionInfo(ByteString createTransactionInfo) {
        this.createTransactionInfo = createTransactionInfo;
    }

    public void setLastTransactionInfo(ByteString lastTransactionInfo) {
        this.lastTransactionInfo = lastTransactionInfo;
    }

    @VisibleForTesting
    public static String generateName(long initialTime) {
        String timePattern = "yyyyMMdd-HHmmss.SSS";
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(timePattern);
        Instant instant = Instant.ofEpochMilli(initialTime);
        return "s" + formatter.format(ZonedDateTime.ofInstant(instant, ZoneId.of("UTC")));
    }

    public static SnapshotInfo newInstance(String volumeName, String bucketName, String snapshotName, UUID snapshotId, long creationTime) {
        Builder builder = new Builder();
        if (StringUtils.isBlank(snapshotName)) {
            snapshotName = SnapshotInfo.generateName(creationTime);
        }
        builder.setSnapshotId(snapshotId).setName(snapshotName).setCreationTime(creationTime).setDeletionTime(-1L).setPathPreviousSnapshotId(INITIAL_SNAPSHOT_ID).setGlobalPreviousSnapshotId(INITIAL_SNAPSHOT_ID).setSnapshotPath(volumeName + "/" + bucketName).setVolumeName(volumeName).setBucketName(bucketName).setDeepClean(false).setDeepCleanedDeletedDir(false);
        if (snapshotId != null) {
            builder.setCheckpointDir(SnapshotInfo.getCheckpointDirName(snapshotId));
        }
        return builder.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SnapshotInfo that = (SnapshotInfo)o;
        return this.creationTime == that.creationTime && this.deletionTime == that.deletionTime && this.snapshotId.equals(that.snapshotId) && this.name.equals(that.name) && this.volumeName.equals(that.volumeName) && this.bucketName.equals(that.bucketName) && this.snapshotStatus == that.snapshotStatus && Objects.equals(this.pathPreviousSnapshotId, that.pathPreviousSnapshotId) && Objects.equals(this.globalPreviousSnapshotId, that.globalPreviousSnapshotId) && this.snapshotPath.equals(that.snapshotPath) && this.checkpointDir.equals(that.checkpointDir) && this.deepClean == that.deepClean && this.sstFiltered == that.sstFiltered && this.referencedSize == that.referencedSize && this.referencedReplicatedSize == that.referencedReplicatedSize && this.exclusiveSize == that.exclusiveSize && this.exclusiveReplicatedSize == that.exclusiveReplicatedSize && this.deepCleanedDeletedDir == that.deepCleanedDeletedDir && Objects.equals(this.lastTransactionInfo, that.lastTransactionInfo) && Objects.equals(this.createTransactionInfo, that.createTransactionInfo);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.snapshotId, this.name, this.volumeName, this.bucketName, this.snapshotStatus, this.creationTime, this.deletionTime, this.pathPreviousSnapshotId, this.globalPreviousSnapshotId, this.snapshotPath, this.checkpointDir, this.deepClean, this.sstFiltered, this.referencedSize, this.referencedReplicatedSize, this.exclusiveSize, this.exclusiveReplicatedSize, this.deepCleanedDeletedDir, this.lastTransactionInfo, this.createTransactionInfo});
    }

    @Override
    public SnapshotInfo copyObject() {
        return this.toBuilder().build();
    }

    public String toString() {
        return "SnapshotInfo{snapshotId: '" + this.snapshotId + '\'' + ", name: '" + this.name + '\'' + ", volumeName: '" + this.volumeName + '\'' + ", bucketName: '" + this.bucketName + '\'' + ", snapshotStatus: '" + (Object)((Object)this.snapshotStatus) + '\'' + ", creationTime: '" + this.creationTime + '\'' + ", deletionTime: '" + this.deletionTime + '\'' + ", pathPreviousSnapshotId: '" + this.pathPreviousSnapshotId + '\'' + ", globalPreviousSnapshotId: '" + this.globalPreviousSnapshotId + '\'' + ", snapshotPath: '" + this.snapshotPath + '\'' + ", checkpointDir: '" + this.checkpointDir + '\'' + ", dbTxSequenceNumber: '" + this.dbTxSequenceNumber + '\'' + ", deepClean: '" + this.deepClean + '\'' + ", sstFiltered: '" + this.sstFiltered + '\'' + ", referencedSize: '" + this.referencedSize + '\'' + ", referencedReplicatedSize: '" + this.referencedReplicatedSize + '\'' + ", exclusiveSize: '" + this.exclusiveSize + '\'' + ", exclusiveReplicatedSize: '" + this.exclusiveReplicatedSize + '\'' + ", exclusiveSizeDeltaFromDirDeepCleaning: '" + this.exclusiveSizeDeltaFromDirDeepCleaning + '\'' + ", exclusiveReplicatedSizeDeltaFromDirDeepCleaning: '" + this.exclusiveReplicatedSizeDeltaFromDirDeepCleaning + "', deepCleanedDeletedDir: '" + this.deepCleanedDeletedDir + '\'' + ", lastTransactionInfo: '" + this.lastTransactionInfo + '\'' + ", createTransactionInfo: '" + this.createTransactionInfo + '\'' + '}';
    }

    public static class Builder {
        private UUID snapshotId;
        private String name;
        private String volumeName;
        private String bucketName;
        private SnapshotStatus snapshotStatus = SnapshotStatus.DEFAULT;
        private long creationTime;
        private long deletionTime;
        private UUID pathPreviousSnapshotId;
        private UUID globalPreviousSnapshotId;
        private String snapshotPath;
        private String checkpointDir;
        private long dbTxSequenceNumber;
        private boolean deepClean;
        private boolean sstFiltered;
        private long referencedSize;
        private long referencedReplicatedSize;
        private long exclusiveSize;
        private long exclusiveReplicatedSize;
        private long exclusiveSizeDeltaFromDirDeepCleaning;
        private long exclusiveReplicatedSizeDeltaFromDirDeepCleaning;
        private boolean deepCleanedDeletedDir;
        private ByteString createTransactionInfo;
        private ByteString lastTransactionInfo;

        public Builder setSnapshotId(UUID snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setVolumeName(String volumeName) {
            this.volumeName = volumeName;
            return this;
        }

        public Builder setBucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public Builder setSnapshotStatus(SnapshotStatus snapshotStatus) {
            this.snapshotStatus = snapshotStatus;
            return this;
        }

        public Builder setCreationTime(long crTime) {
            this.creationTime = crTime;
            return this;
        }

        public Builder setDeletionTime(long delTime) {
            this.deletionTime = delTime;
            return this;
        }

        public Builder setPathPreviousSnapshotId(UUID pathPreviousSnapshotId) {
            this.pathPreviousSnapshotId = pathPreviousSnapshotId;
            return this;
        }

        public Builder setGlobalPreviousSnapshotId(UUID globalPreviousSnapshotId) {
            this.globalPreviousSnapshotId = globalPreviousSnapshotId;
            return this;
        }

        public Builder setSnapshotPath(String snapshotPath) {
            this.snapshotPath = snapshotPath;
            return this;
        }

        public Builder setCheckpointDir(String checkpointDir) {
            this.checkpointDir = checkpointDir;
            return this;
        }

        public Builder setDbTxSequenceNumber(long dbTxSequenceNumber) {
            this.dbTxSequenceNumber = dbTxSequenceNumber;
            return this;
        }

        public Builder setDeepClean(boolean deepClean) {
            this.deepClean = deepClean;
            return this;
        }

        public Builder setSstFiltered(boolean sstFiltered) {
            this.sstFiltered = sstFiltered;
            return this;
        }

        public Builder setReferencedSize(long referencedSize) {
            this.referencedSize = referencedSize;
            return this;
        }

        public Builder setReferencedReplicatedSize(long referencedReplicatedSize) {
            this.referencedReplicatedSize = referencedReplicatedSize;
            return this;
        }

        public Builder setExclusiveSize(long exclusiveSize) {
            this.exclusiveSize = exclusiveSize;
            return this;
        }

        public Builder setExclusiveReplicatedSize(long exclusiveReplicatedSize) {
            this.exclusiveReplicatedSize = exclusiveReplicatedSize;
            return this;
        }

        public Builder setExclusiveSizeDeltaFromDirDeepCleaning(long exclusiveSizeDeltaFromDirDeepCleaning) {
            this.exclusiveSizeDeltaFromDirDeepCleaning = exclusiveSizeDeltaFromDirDeepCleaning;
            return this;
        }

        public Builder setExclusiveReplicatedSizeDeltaFromDirDeepCleaning(long exclusiveReplicatedSizeDeltaFromDirDeepCleaning) {
            this.exclusiveReplicatedSizeDeltaFromDirDeepCleaning = exclusiveReplicatedSizeDeltaFromDirDeepCleaning;
            return this;
        }

        public Builder setDeepCleanedDeletedDir(boolean deepCleanedDeletedDir) {
            this.deepCleanedDeletedDir = deepCleanedDeletedDir;
            return this;
        }

        public Builder setCreateTransactionInfo(ByteString createTransactionInfo) {
            this.createTransactionInfo = createTransactionInfo;
            return this;
        }

        public Builder setLastTransactionInfo(ByteString lastTransactionInfo) {
            this.lastTransactionInfo = lastTransactionInfo;
            return this;
        }

        public SnapshotInfo build() {
            Preconditions.checkNotNull(this.name);
            return new SnapshotInfo(this);
        }
    }

    public static enum SnapshotStatus {
        SNAPSHOT_ACTIVE,
        SNAPSHOT_DELETED;

        public static final SnapshotStatus DEFAULT;

        public OzoneManagerProtocolProtos.SnapshotStatusProto toProto() {
            switch (this.ordinal()) {
                case 0: {
                    return OzoneManagerProtocolProtos.SnapshotStatusProto.SNAPSHOT_ACTIVE;
                }
                case 1: {
                    return OzoneManagerProtocolProtos.SnapshotStatusProto.SNAPSHOT_DELETED;
                }
            }
            throw new IllegalStateException("BUG: missing valid SnapshotStatus, found status=" + (Object)((Object)this));
        }

        public static SnapshotStatus valueOf(OzoneManagerProtocolProtos.SnapshotStatusProto status) {
            switch (status) {
                case SNAPSHOT_ACTIVE: {
                    return SNAPSHOT_ACTIVE;
                }
                case SNAPSHOT_DELETED: {
                    return SNAPSHOT_DELETED;
                }
            }
            throw new IllegalStateException("BUG: missing valid SnapshotStatus, found status=" + status);
        }

        static {
            DEFAULT = SNAPSHOT_ACTIVE;
        }
    }
}

