/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.shaded.com.google.protobuf.ByteString;
import org.apache.hadoop.shaded.com.google.protobuf.Proto2Utils;
import org.apache.ozone.shaded.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.ozone.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.ozone.shaded.net.jcip.annotations.Immutable;
import org.apache.ozone.shaded.org.apache.ratis.util.MemoizedSupplier;

@Immutable
public final class OzoneAcl {
    private static final String ACL_SCOPE_REGEX = ".*\\[(ACCESS|DEFAULT)\\]";
    public static final OzoneAcl LINK_BUCKET_DEFAULT_ACL = OzoneAcl.of(IAccessAuthorizer.ACLIdentityType.WORLD, "", AclScope.ACCESS, IAccessAuthorizer.ACLType.READ, IAccessAuthorizer.ACLType.WRITE);
    private final IAccessAuthorizer.ACLIdentityType type;
    private final String name;
    @JsonIgnore
    private final int aclBits;
    private final AclScope aclScope;
    @JsonIgnore
    private final Supplier<String> toStringMethod;
    @JsonIgnore
    private final Supplier<Integer> hashCodeMethod;

    public static OzoneAcl of(IAccessAuthorizer.ACLIdentityType type, String name, AclScope scope, IAccessAuthorizer.ACLType ... acls) {
        return new OzoneAcl(type, name, scope, OzoneAcl.toInt(acls));
    }

    public static OzoneAcl of(IAccessAuthorizer.ACLIdentityType type, String name, AclScope scope, Set<IAccessAuthorizer.ACLType> acls) {
        return new OzoneAcl(type, name, scope, OzoneAcl.toInt(acls));
    }

    private OzoneAcl(IAccessAuthorizer.ACLIdentityType type, String name, AclScope scope, int acls) {
        this.name = OzoneAcl.validateNameAndType(type, name);
        this.type = type;
        this.aclScope = scope;
        this.aclBits = acls;
        this.toStringMethod = MemoizedSupplier.valueOf(() -> (Object)((Object)this.getType()) + ":" + this.getName() + ":" + IAccessAuthorizer.ACLType.getACLString(BitSet.valueOf(this.getAclByteString().asReadOnlyByteBuffer())) + "[" + (Object)((Object)this.getAclScope()) + "]");
        this.hashCodeMethod = MemoizedSupplier.valueOf(() -> Objects.hash(new Object[]{this.getName(), BitSet.valueOf(this.getAclByteString().asReadOnlyByteBuffer()), this.getType().toString(), this.getAclScope()}));
    }

    private static int toInt(int aclTypeOrdinal) {
        return 1 << aclTypeOrdinal;
    }

    private static int toInt(IAccessAuthorizer.ACLType acl) {
        return OzoneAcl.toInt(acl.ordinal());
    }

    private static int toInt(IAccessAuthorizer.ACLType[] acls) {
        if (acls == null) {
            return 0;
        }
        int value = 0;
        for (IAccessAuthorizer.ACLType acl : acls) {
            value |= OzoneAcl.toInt(acl);
        }
        return value;
    }

    private static int toInt(Iterable<IAccessAuthorizer.ACLType> acls) {
        if (acls == null) {
            return 0;
        }
        int value = 0;
        for (IAccessAuthorizer.ACLType acl : acls) {
            value |= OzoneAcl.toInt(acl);
        }
        return value;
    }

    private static String validateNameAndType(IAccessAuthorizer.ACLIdentityType type, String name) {
        Objects.requireNonNull(type);
        if (type == IAccessAuthorizer.ACLIdentityType.WORLD || type == IAccessAuthorizer.ACLIdentityType.ANONYMOUS) {
            if (!(name.equals(IAccessAuthorizer.ACLIdentityType.WORLD.name()) || name.equals(IAccessAuthorizer.ACLIdentityType.ANONYMOUS.name()) || name.isEmpty())) {
                throw new IllegalArgumentException("Expected name " + type.name() + ", but was: " + name);
            }
            return type.name();
        }
        if ((type == IAccessAuthorizer.ACLIdentityType.USER || type == IAccessAuthorizer.ACLIdentityType.GROUP) && name.isEmpty()) {
            throw new IllegalArgumentException((Object)((Object)type) + " name is required");
        }
        return name;
    }

    public OzoneAcl withScope(AclScope scope) {
        return scope == this.aclScope ? this : new OzoneAcl(this.type, this.name, scope, this.aclBits);
    }

    public static OzoneAcl parseAcl(String acl) throws IllegalArgumentException {
        if (acl == null || acl.isEmpty()) {
            throw new IllegalArgumentException("ACLs cannot be null or empty");
        }
        String[] parts = acl.trim().split(":");
        if (parts.length < 3) {
            throw new IllegalArgumentException("ACLs are not in expected format");
        }
        IAccessAuthorizer.ACLIdentityType aclType = IAccessAuthorizer.ACLIdentityType.valueOf(parts[0].toUpperCase());
        String bits = parts[2];
        AclScope aclScope = AclScope.ACCESS;
        if (parts[2].matches(ACL_SCOPE_REGEX)) {
            int indexOfOpenBracket = parts[2].indexOf("[");
            bits = parts[2].substring(0, indexOfOpenBracket);
            aclScope = AclScope.valueOf(parts[2].substring(indexOfOpenBracket + 1, parts[2].indexOf("]")));
        }
        EnumSet<IAccessAuthorizer.ACLType> acls = EnumSet.noneOf(IAccessAuthorizer.ACLType.class);
        for (char ch : bits.toCharArray()) {
            acls.add(IAccessAuthorizer.ACLType.getACLRight(String.valueOf(ch)));
        }
        return OzoneAcl.of(aclType, parts[1], aclScope, acls);
    }

    public static List<OzoneAcl> parseAcls(String acls) throws IllegalArgumentException {
        if (acls == null || acls.isEmpty()) {
            throw new IllegalArgumentException("ACLs cannot be null or empty");
        }
        String[] parts = acls.trim().split(",");
        if (parts.length < 1) {
            throw new IllegalArgumentException("ACLs are not in expected format");
        }
        ArrayList<OzoneAcl> ozAcls = new ArrayList<OzoneAcl>();
        for (String acl : parts) {
            ozAcls.add(OzoneAcl.parseAcl(acl));
        }
        return ozAcls;
    }

    public static OzoneManagerProtocolProtos.OzoneAclInfo toProtobuf(OzoneAcl acl) {
        OzoneManagerProtocolProtos.OzoneAclInfo.Builder builder = OzoneManagerProtocolProtos.OzoneAclInfo.newBuilder().setName(acl.getName()).setType(OzoneManagerProtocolProtos.OzoneAclInfo.OzoneAclType.valueOf(acl.getType().name())).setAclScope(OzoneManagerProtocolProtos.OzoneAclInfo.OzoneAclScope.valueOf(acl.getAclScope().name())).setRights(acl.getAclByteString());
        return builder.build();
    }

    public static OzoneAcl fromProtobuf(OzoneManagerProtocolProtos.OzoneAclInfo protoAcl) {
        byte[] bytes = protoAcl.getRights().toByteArray();
        if (bytes.length > 4) {
            throw new AssertionError((Object)("Expected at most 4 bytes but got " + bytes.length));
        }
        int aclRights = 0;
        for (int i = 0; i < bytes.length; ++i) {
            aclRights |= (bytes[i] & 0xFF) << i * 8;
        }
        return new OzoneAcl(IAccessAuthorizer.ACLIdentityType.valueOf(protoAcl.getType().name()), protoAcl.getName(), AclScope.valueOf(protoAcl.getAclScope().name()), aclRights);
    }

    public AclScope getAclScope() {
        return this.aclScope;
    }

    public String toString() {
        return this.toStringMethod.get();
    }

    public int hashCode() {
        return this.hashCodeMethod.get();
    }

    public String getName() {
        return this.name;
    }

    @JsonIgnore
    public boolean isEmpty() {
        return this.aclBits == 0;
    }

    @VisibleForTesting
    public boolean isSet(IAccessAuthorizer.ACLType acl) {
        return (this.aclBits & OzoneAcl.toInt(acl)) != 0;
    }

    public boolean checkAccess(IAccessAuthorizer.ACLType acl) {
        return (this.isSet(acl) || this.isSet(IAccessAuthorizer.ACLType.ALL)) && !this.isSet(IAccessAuthorizer.ACLType.NONE);
    }

    public OzoneAcl add(OzoneAcl other) {
        return this.apply(bits -> bits | other.aclBits);
    }

    public OzoneAcl remove(OzoneAcl other) {
        return this.apply(bits -> bits & ~other.aclBits);
    }

    private OzoneAcl apply(IntFunction<Integer> op) {
        int applied = op.apply(this.aclBits);
        return applied == this.aclBits ? this : new OzoneAcl(this.type, this.name, this.aclScope, applied);
    }

    @JsonIgnore
    public ByteString getAclByteString() {
        byte[] byArray;
        byte first = (byte)this.aclBits;
        byte second = (byte)(this.aclBits >>> 8);
        if (second != 0) {
            byte[] byArray2 = new byte[2];
            byArray2[0] = first;
            byArray = byArray2;
            byArray2[1] = second;
        } else {
            byte[] byArray3 = new byte[1];
            byArray = byArray3;
            byArray3[0] = first;
        }
        byte[] bytes = byArray;
        return Proto2Utils.unsafeByteString(bytes);
    }

    @JsonIgnore
    public List<String> getAclStringList() {
        return OzoneAcl.getAclList(this.aclBits, Enum::name);
    }

    public List<IAccessAuthorizer.ACLType> getAclList() {
        return OzoneAcl.getAclList(this.aclBits, Function.identity());
    }

    public Set<IAccessAuthorizer.ACLType> getAclSet() {
        return Collections.unmodifiableSet(EnumSet.copyOf(this.getAclList()));
    }

    private static <T> List<T> getAclList(int aclBits, Function<IAccessAuthorizer.ACLType, T> converter) {
        if (aclBits == 0) {
            return Collections.emptyList();
        }
        ArrayList<T> toReturn = new ArrayList<T>(Integer.bitCount(aclBits));
        for (int i = 0; i < IAccessAuthorizer.ACLType.values().length; ++i) {
            if ((OzoneAcl.toInt(i) & aclBits) == 0) continue;
            toReturn.add(converter.apply(IAccessAuthorizer.ACLType.values()[i]));
        }
        return Collections.unmodifiableList(toReturn);
    }

    public IAccessAuthorizer.ACLIdentityType getType() {
        return this.type;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        OzoneAcl otherAcl = (OzoneAcl)obj;
        return otherAcl.getName().equals(this.getName()) && otherAcl.getType().equals((Object)this.getType()) && this.aclBits == otherAcl.aclBits && otherAcl.getAclScope().equals((Object)this.getAclScope());
    }

    public static enum AclScope {
        ACCESS,
        DEFAULT;

    }
}

