/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils.db;

import java.nio.ByteBuffer;
import org.apache.hadoop.hdds.utils.db.Codec;
import org.apache.hadoop.hdds.utils.db.CodecBuffer;
import org.apache.ozone.shaded.jakarta.annotation.Nonnull;

public final class ShortCodec
implements Codec<Short> {
    private static final ShortCodec INSTANCE = new ShortCodec();

    public static ShortCodec get() {
        return INSTANCE;
    }

    private ShortCodec() {
    }

    @Override
    public Class<Short> getTypeClass() {
        return Short.class;
    }

    @Override
    public boolean supportCodecBuffer() {
        return true;
    }

    @Override
    public CodecBuffer toCodecBuffer(@Nonnull Short object, CodecBuffer.Allocator allocator) {
        return ((CodecBuffer)allocator.apply(2)).putShort(object);
    }

    @Override
    public Short fromCodecBuffer(@Nonnull CodecBuffer buffer) {
        return buffer.asReadOnlyByteBuffer().getShort();
    }

    @Override
    public byte[] toPersistedFormat(Short object) {
        return ByteBuffer.wrap(new byte[2]).putShort(object).array();
    }

    @Override
    public Short fromPersistedFormat(byte[] rawData) {
        return ByteBuffer.wrap(rawData).getShort();
    }

    @Override
    public Short copyObject(Short object) {
        return object;
    }
}

