/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.tracing;

import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.tracing.TraceAllMethod;
import org.apache.ozone.shaded.io.opentelemetry.api.OpenTelemetry;
import org.apache.ozone.shaded.io.opentelemetry.api.common.AttributeKey;
import org.apache.ozone.shaded.io.opentelemetry.api.common.Attributes;
import org.apache.ozone.shaded.io.opentelemetry.api.trace.Span;
import org.apache.ozone.shaded.io.opentelemetry.api.trace.StatusCode;
import org.apache.ozone.shaded.io.opentelemetry.api.trace.Tracer;
import org.apache.ozone.shaded.io.opentelemetry.api.trace.propagation.W3CTraceContextPropagator;
import org.apache.ozone.shaded.io.opentelemetry.context.Context;
import org.apache.ozone.shaded.io.opentelemetry.context.Scope;
import org.apache.ozone.shaded.io.opentelemetry.context.propagation.TextMapGetter;
import org.apache.ozone.shaded.io.opentelemetry.exporter.otlp.trace.OtlpGrpcSpanExporter;
import org.apache.ozone.shaded.io.opentelemetry.sdk.OpenTelemetrySdk;
import org.apache.ozone.shaded.io.opentelemetry.sdk.resources.Resource;
import org.apache.ozone.shaded.io.opentelemetry.sdk.trace.SdkTracerProvider;
import org.apache.ozone.shaded.io.opentelemetry.sdk.trace.export.SimpleSpanProcessor;
import org.apache.ozone.shaded.io.opentelemetry.sdk.trace.samplers.Sampler;
import org.apache.ozone.shaded.org.apache.ratis.util.function.CheckedRunnable;
import org.apache.ozone.shaded.org.apache.ratis.util.function.CheckedSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TracingUtil {
    private static final Logger LOG = LoggerFactory.getLogger(TracingUtil.class);
    private static final String NULL_SPAN_AS_STRING = "";
    private static final String OTEL_EXPORTER_OTLP_ENDPOINT = "OTEL_EXPORTER_OTLP_ENDPOINT";
    private static final String OTEL_EXPORTER_OTLP_ENDPOINT_DEFAULT = "http://localhost:4317";
    private static final String OTEL_TRACES_SAMPLER_ARG = "OTEL_TRACES_SAMPLER_ARG";
    private static final double OTEL_TRACES_SAMPLER_RATIO_DEFAULT = 1.0;
    private static volatile boolean isInit = false;
    private static Tracer tracer = OpenTelemetry.noop().getTracer("noop");

    private TracingUtil() {
    }

    public static void initTracing(String serviceName, ConfigurationSource conf) {
        if (!TracingUtil.isTracingEnabled(conf) || isInit) {
            return;
        }
        try {
            TracingUtil.initialize(serviceName);
            isInit = true;
            LOG.info("Initialized tracing service: {}", (Object)serviceName);
        }
        catch (Exception e) {
            LOG.error("Failed to initialize tracing", (Throwable)e);
        }
    }

    private static void initialize(String serviceName) {
        String otelEndPoint = System.getenv(OTEL_EXPORTER_OTLP_ENDPOINT);
        if (otelEndPoint == null || otelEndPoint.isEmpty()) {
            otelEndPoint = OTEL_EXPORTER_OTLP_ENDPOINT_DEFAULT;
        }
        double samplerRatio = 1.0;
        try {
            String sampleStrRatio = System.getenv(OTEL_TRACES_SAMPLER_ARG);
            if (sampleStrRatio != null && !sampleStrRatio.isEmpty()) {
                samplerRatio = Double.parseDouble(System.getenv(OTEL_TRACES_SAMPLER_ARG));
            }
        }
        catch (NumberFormatException sampleStrRatio) {
            // empty catch block
        }
        Resource resource = Resource.create(Attributes.of(AttributeKey.stringKey("service.name"), serviceName));
        OtlpGrpcSpanExporter spanExporter = OtlpGrpcSpanExporter.builder().setEndpoint(otelEndPoint).build();
        SimpleSpanProcessor spanProcessor = SimpleSpanProcessor.builder(spanExporter).build();
        SdkTracerProvider tracerProvider = SdkTracerProvider.builder().addSpanProcessor(spanProcessor).setResource(resource).setSampler(Sampler.traceIdRatioBased(samplerRatio)).build();
        OpenTelemetrySdk openTelemetry = OpenTelemetrySdk.builder().setTracerProvider(tracerProvider).build();
        tracer = openTelemetry.getTracer(serviceName);
    }

    public static String exportCurrentSpan() {
        Span currentSpan = Span.current();
        if (!currentSpan.getSpanContext().isValid()) {
            return NULL_SPAN_AS_STRING;
        }
        StringBuilder builder = new StringBuilder();
        W3CTraceContextPropagator propagator = W3CTraceContextPropagator.getInstance();
        propagator.inject(Context.current(), builder, (carrier, key, value) -> carrier.append(key).append('=').append(value).append(';'));
        return builder.toString();
    }

    public static Span importAndCreateSpan(String name, String encodedParent) {
        if (encodedParent == null || encodedParent.isEmpty()) {
            return tracer.spanBuilder(name).setNoParent().startSpan();
        }
        W3CTraceContextPropagator propagator = W3CTraceContextPropagator.getInstance();
        Context extract = propagator.extract(Context.current(), encodedParent, new TextExtractor());
        return tracer.spanBuilder(name).setParent(extract).startSpan();
    }

    public static <T> T createProxy(T delegate, Class<T> itf, ConfigurationSource conf) {
        if (!TracingUtil.isTracingEnabled(conf)) {
            return delegate;
        }
        Class<?> aClass = delegate.getClass();
        return itf.cast(Proxy.newProxyInstance(aClass.getClassLoader(), new Class[]{itf}, new TraceAllMethod<T>(delegate, itf.getSimpleName())));
    }

    public static boolean isTracingEnabled(ConfigurationSource conf) {
        return conf.getBoolean("hdds.tracing.enabled", false);
    }

    public static <E extends Exception> void executeInNewSpan(String spanName, CheckedRunnable<E> runnable2) throws E {
        Span span = tracer.spanBuilder(spanName).setNoParent().startSpan();
        TracingUtil.executeInSpan(span, runnable2);
    }

    public static <R, E extends Exception> R executeInNewSpan(String spanName, CheckedSupplier<R, E> supplier) throws E {
        Span span = tracer.spanBuilder(spanName).setNoParent().startSpan();
        return TracingUtil.executeInSpan(span, supplier);
    }

    private static <R, E extends Exception> R executeInSpan(Span span, CheckedSupplier<R, E> supplier) throws E {
        try {
            R r;
            block11: {
                Scope ignored = span.makeCurrent();
                try {
                    r = supplier.get();
                    if (ignored == null) break block11;
                    ignored.close();
                }
                catch (Throwable throwable) {
                    try {
                        if (ignored != null) {
                            try {
                                ignored.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception ex) {
                        span.addEvent("Failed with exception: " + ex.getMessage());
                        span.setStatus(StatusCode.ERROR);
                        throw ex;
                    }
                }
            }
            return r;
        }
        finally {
            span.end();
        }
    }

    private static <E extends Exception> void executeInSpan(Span span, CheckedRunnable<E> runnable2) throws E {
        try (Scope ignored = span.makeCurrent();){
            runnable2.run();
        }
        catch (Exception ex) {
            span.addEvent("Failed with exception: " + ex.getMessage());
            span.setStatus(StatusCode.ERROR);
            throw ex;
        }
        finally {
            span.end();
        }
    }

    public static <E extends Exception> void executeAsChildSpan(String spanName, String parentName, CheckedRunnable<E> runnable2) throws E {
        Span span = TracingUtil.importAndCreateSpan(spanName, parentName);
        TracingUtil.executeInSpan(span, runnable2);
    }

    public static TraceCloseable createActivatedSpan(String spanName) {
        Span span = tracer.spanBuilder(spanName).setNoParent().startSpan();
        Scope scope = span.makeCurrent();
        return () -> {
            scope.close();
            span.end();
        };
    }

    public static Span getActiveSpan() {
        return Span.current();
    }

    public static class TextExtractor
    implements TextMapGetter<String> {
        private Map<String, String> map = new HashMap<String, String>();

        @Override
        public Iterable<String> keys(String carrier) {
            if (this.map.isEmpty()) {
                this.parse(carrier);
            }
            return this.map.keySet();
        }

        @Override
        public String get(String carrier, String key) {
            if (this.map.isEmpty()) {
                this.parse(carrier);
            }
            return this.map.get(key);
        }

        private void parse(String carrier) {
            String[] parts;
            if (carrier == null || carrier.isEmpty()) {
                return;
            }
            for (String part : parts = carrier.split(";")) {
                String[] kv = part.split("=");
                if (kv.length != 2) continue;
                this.map.put(kv[0].trim(), kv[1].trim());
            }
        }
    }

    public static interface TraceCloseable
    extends AutoCloseable {
        @Override
        public void close();
    }
}

