/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.layout;

import com.mxgraph.layout.mxGraphLayout;
import com.mxgraph.model.mxGeometry;
import com.mxgraph.model.mxIGraphModel;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.view.mxGraph;
import java.util.ArrayList;
import java.util.Hashtable;

public class mxFastOrganicLayout
extends mxGraphLayout {
    protected boolean useInputOrigin = true;
    protected boolean resetEdges = true;
    protected boolean disableEdgeStyle = true;
    protected double forceConstant = 50.0;
    protected double forceConstantSquared = 0.0;
    protected double minDistanceLimit = 2.0;
    protected double minDistanceLimitSquared = 0.0;
    protected double maxDistanceLimit = 500.0;
    protected double initialTemp = 200.0;
    protected double temperature = 0.0;
    protected double maxIterations = 0.0;
    protected double iteration = 0.0;
    protected Object[] vertexArray;
    protected double[] dispX;
    protected double[] dispY;
    protected double[][] cellLocation;
    protected double[] radius;
    protected double[] radiusSquared;
    protected boolean[] isMoveable;
    protected int[][] neighbours;
    protected boolean allowedToRun = true;
    protected Hashtable<Object, Integer> indices = new Hashtable();

    public mxFastOrganicLayout(mxGraph graph) {
        super(graph);
    }

    public boolean isVertexIgnored(Object vertex) {
        return super.isVertexIgnored(vertex) || this.graph.getConnections(vertex).length == 0;
    }

    public boolean isUseInputOrigin() {
        return this.useInputOrigin;
    }

    public void setUseInputOrigin(boolean value) {
        this.useInputOrigin = value;
    }

    public boolean isResetEdges() {
        return this.resetEdges;
    }

    public void setResetEdges(boolean value) {
        this.resetEdges = value;
    }

    public boolean isDisableEdgeStyle() {
        return this.disableEdgeStyle;
    }

    public void setDisableEdgeStyle(boolean value) {
        this.disableEdgeStyle = value;
    }

    public double getMaxIterations() {
        return this.maxIterations;
    }

    public void setMaxIterations(double value) {
        this.maxIterations = value;
    }

    public double getForceConstant() {
        return this.forceConstant;
    }

    public void setForceConstant(double value) {
        this.forceConstant = value;
    }

    public double getMinDistanceLimit() {
        return this.minDistanceLimit;
    }

    public void setMinDistanceLimit(double value) {
        this.minDistanceLimit = value;
    }

    public double getMaxDistanceLimit() {
        return this.maxDistanceLimit;
    }

    public void setMaxDistanceLimit(double maxDistanceLimit) {
        this.maxDistanceLimit = maxDistanceLimit;
    }

    public double getInitialTemp() {
        return this.initialTemp;
    }

    public void setInitialTemp(double value) {
        this.initialTemp = value;
    }

    protected void reduceTemperature() {
        this.temperature = this.initialTemp * (1.0 - this.iteration / this.maxIterations);
    }

    public void moveCell(Object cell, double x, double y) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Object parent) {
        int i;
        mxIGraphModel model = this.graph.getModel();
        Object[] vertices = this.graph.getChildVertices(parent);
        ArrayList<Object> tmp = new ArrayList<Object>(vertices.length);
        for (int i2 = 0; i2 < vertices.length; ++i2) {
            if (this.isVertexIgnored(vertices[i2])) continue;
            tmp.add(vertices[i2]);
        }
        this.vertexArray = tmp.toArray();
        mxRectangle initialBounds = this.useInputOrigin ? this.graph.getBoundsForCells(this.vertexArray, false, false, true) : null;
        int n = this.vertexArray.length;
        this.dispX = new double[n];
        this.dispY = new double[n];
        this.cellLocation = new double[n][];
        this.isMoveable = new boolean[n];
        this.neighbours = new int[n][];
        this.radius = new double[n];
        this.radiusSquared = new double[n];
        this.minDistanceLimitSquared = this.minDistanceLimit * this.minDistanceLimit;
        if (this.forceConstant < 0.001) {
            this.forceConstant = 0.001;
        }
        this.forceConstantSquared = this.forceConstant * this.forceConstant;
        for (i = 0; i < this.vertexArray.length; ++i) {
            Object vertex = this.vertexArray[i];
            this.cellLocation[i] = new double[2];
            this.indices.put(vertex, new Integer(i));
            mxRectangle bounds = this.getVertexBounds(vertex);
            double width = bounds.getWidth();
            double height = bounds.getHeight();
            double x = bounds.getX();
            double y = bounds.getY();
            this.cellLocation[i][0] = x + width / 2.0;
            this.cellLocation[i][1] = y + height / 2.0;
            this.radius[i] = Math.min(width, height);
            this.radiusSquared[i] = this.radius[i] * this.radius[i];
        }
        model.beginUpdate();
        try {
            double dy;
            for (i = 0; i < n; ++i) {
                this.dispX[i] = 0.0;
                this.dispY[i] = 0.0;
                this.isMoveable[i] = this.isVertexMovable(this.vertexArray[i]);
                Object[] edges = this.graph.getConnections(this.vertexArray[i], parent);
                for (int k = 0; k < edges.length; ++k) {
                    if (this.isResetEdges()) {
                        this.graph.resetEdge(edges[k]);
                    }
                    if (!this.isDisableEdgeStyle()) continue;
                    this.setEdgeStyleEnabled(edges[k], false);
                }
                Object[] cells = this.graph.getOpposites(edges, this.vertexArray[i]);
                this.neighbours[i] = new int[cells.length];
                for (int j = 0; j < cells.length; ++j) {
                    Integer index = this.indices.get(cells[j]);
                    this.neighbours[i][j] = index != null ? index : i;
                }
            }
            this.temperature = this.initialTemp;
            if (this.maxIterations == 0.0) {
                this.maxIterations = 20.0 * Math.sqrt(n);
            }
            this.iteration = 0.0;
            while (this.iteration < this.maxIterations) {
                if (!this.allowedToRun) {
                    return;
                }
                this.calcRepulsion();
                this.calcAttraction();
                this.calcPositions();
                this.reduceTemperature();
                this.iteration += 1.0;
            }
            Double minx = null;
            Double miny = null;
            for (int i3 = 0; i3 < this.vertexArray.length; ++i3) {
                Object vertex = this.vertexArray[i3];
                mxGeometry geo = model.getGeometry(vertex);
                if (geo == null) continue;
                double[] dArray = this.cellLocation[i3];
                dArray[0] = dArray[0] - geo.getWidth() / 2.0;
                double[] dArray2 = this.cellLocation[i3];
                dArray2[1] = dArray2[1] - geo.getHeight() / 2.0;
                double x = this.graph.snap(this.cellLocation[i3][0]);
                double y = this.graph.snap(this.cellLocation[i3][1]);
                this.setVertexLocation(vertex, x, y);
                minx = minx == null ? new Double(x) : new Double(Math.min(minx, x));
                miny = miny == null ? new Double(y) : new Double(Math.min(miny, y));
            }
            double dx = minx != null ? -minx.doubleValue() - 1.0 : 0.0;
            double d = dy = miny != null ? -miny.doubleValue() - 1.0 : 0.0;
            if (initialBounds != null) {
                dx += initialBounds.getX();
                dy += initialBounds.getY();
            }
            this.graph.moveCells(this.vertexArray, dx, dy);
        }
        finally {
            model.endUpdate();
        }
    }

    protected void calcPositions() {
        for (int index = 0; index < this.vertexArray.length; ++index) {
            if (!this.isMoveable[index]) continue;
            double deltaLength = Math.sqrt(this.dispX[index] * this.dispX[index] + this.dispY[index] * this.dispY[index]);
            if (deltaLength < 0.001) {
                deltaLength = 0.001;
            }
            double newXDisp = this.dispX[index] / deltaLength * Math.min(deltaLength, this.temperature);
            double newYDisp = this.dispY[index] / deltaLength * Math.min(deltaLength, this.temperature);
            this.dispX[index] = 0.0;
            this.dispY[index] = 0.0;
            double[] dArray = this.cellLocation[index];
            dArray[0] = dArray[0] + newXDisp;
            double[] dArray2 = this.cellLocation[index];
            dArray2[1] = dArray2[1] + newYDisp;
        }
    }

    protected void calcAttraction() {
        for (int i = 0; i < this.vertexArray.length; ++i) {
            for (int k = 0; k < this.neighbours[i].length; ++k) {
                int j = this.neighbours[i][k];
                if (i == j) continue;
                double xDelta = this.cellLocation[i][0] - this.cellLocation[j][0];
                double yDelta = this.cellLocation[i][1] - this.cellLocation[j][1];
                double deltaLengthSquared = xDelta * xDelta + yDelta * yDelta - this.radiusSquared[i] - this.radiusSquared[j];
                if (deltaLengthSquared < this.minDistanceLimitSquared) {
                    deltaLengthSquared = this.minDistanceLimitSquared;
                }
                double deltaLength = Math.sqrt(deltaLengthSquared);
                double force = deltaLengthSquared / this.forceConstant;
                double displacementX = xDelta / deltaLength * force;
                double displacementY = yDelta / deltaLength * force;
                if (this.isMoveable[i]) {
                    int n = i;
                    this.dispX[n] = this.dispX[n] - displacementX;
                    int n2 = i;
                    this.dispY[n2] = this.dispY[n2] - displacementY;
                }
                if (!this.isMoveable[j]) continue;
                int n = j;
                this.dispX[n] = this.dispX[n] + displacementX;
                int n3 = j;
                this.dispY[n3] = this.dispY[n3] + displacementY;
            }
        }
    }

    protected void calcRepulsion() {
        int vertexCount = this.vertexArray.length;
        for (int i = 0; i < vertexCount; ++i) {
            for (int j = i; j < vertexCount; ++j) {
                double deltaLength;
                double deltaLengthWithRadius;
                if (!this.allowedToRun) {
                    return;
                }
                if (j == i) continue;
                double xDelta = this.cellLocation[i][0] - this.cellLocation[j][0];
                double yDelta = this.cellLocation[i][1] - this.cellLocation[j][1];
                if (xDelta == 0.0) {
                    xDelta = 0.01 + Math.random();
                }
                if (yDelta == 0.0) {
                    yDelta = 0.01 + Math.random();
                }
                if ((deltaLengthWithRadius = (deltaLength = Math.sqrt(xDelta * xDelta + yDelta * yDelta)) - this.radius[i] - this.radius[j]) > this.maxDistanceLimit) continue;
                if (deltaLengthWithRadius < this.minDistanceLimit) {
                    deltaLengthWithRadius = this.minDistanceLimit;
                }
                double force = this.forceConstantSquared / deltaLengthWithRadius;
                double displacementX = xDelta / deltaLength * force;
                double displacementY = yDelta / deltaLength * force;
                if (this.isMoveable[i]) {
                    int n = i;
                    this.dispX[n] = this.dispX[n] + displacementX;
                    int n2 = i;
                    this.dispY[n2] = this.dispY[n2] + displacementY;
                }
                if (!this.isMoveable[j]) continue;
                int n = j;
                this.dispX[n] = this.dispX[n] - displacementX;
                int n3 = j;
                this.dispY[n3] = this.dispY[n3] - displacementY;
            }
        }
    }
}

