/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.fs.http.server;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.util.JvmPauseMonitor;
import org.apache.ozone.fs.http.server.FSOperations;
import org.apache.ozone.fs.http.server.metrics.HttpFSServerMetrics;
import org.apache.ozone.lib.server.ServerException;
import org.apache.ozone.lib.service.FileSystemAccess;
import org.apache.ozone.lib.servlet.ServerWebApp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class HttpFSServerWebApp
extends ServerWebApp {
    private static final Logger LOG = LoggerFactory.getLogger(HttpFSServerWebApp.class);
    public static final String NAME = "httpfs";
    public static final String CONF_ADMIN_GROUP = "admin.group";
    private static final AtomicReference<HttpFSServerWebApp> SERVER = new AtomicReference();
    private static final AtomicReference<HttpFSServerMetrics> METRICS = new AtomicReference();
    private String adminGroup;

    public HttpFSServerWebApp() throws IOException {
        super(NAME);
    }

    @Override
    public void init() throws ServerException {
        if (!SERVER.compareAndSet(null, this)) {
            throw new RuntimeException("HttpFSServer server already initialized");
        }
        super.init();
        this.adminGroup = this.getConfig().get(this.getPrefixedName(CONF_ADMIN_GROUP), "admin");
        LOG.info("Connects to FileSystem [{}]", (Object)HttpFSServerWebApp.get().get(FileSystemAccess.class).getFileSystemConfiguration().get("fs.defaultFS"));
        HttpFSServerWebApp.setMetrics(this.getConfig());
    }

    @Override
    public void destroy() {
        SERVER.set(null);
        HttpFSServerMetrics metrics = METRICS.getAndSet(null);
        if (metrics != null) {
            metrics.shutdown();
        }
        super.destroy();
    }

    private static void setMetrics(Configuration config) {
        LOG.info("Initializing HttpFSServerMetrics");
        METRICS.updateAndGet(prev -> prev != null ? prev : HttpFSServerMetrics.create(config, "HttpFSServer"));
        JvmPauseMonitor pauseMonitor = new JvmPauseMonitor();
        pauseMonitor.init(config);
        pauseMonitor.start();
        METRICS.get().getJvmMetrics().setPauseMonitor(pauseMonitor);
        FSOperations.setBufferSize(config);
        DefaultMetricsSystem.initialize((String)"HttpFSServer");
    }

    public static HttpFSServerWebApp get() {
        return SERVER.get();
    }

    public static HttpFSServerMetrics getMetrics() {
        return METRICS.get();
    }

    public String getAdminGroup() {
        return this.adminGroup;
    }
}

