/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation.steps;

import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.core.EntryEventType;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.util.ToHeapDataConverter;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapEntries;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.operation.EntryOperator;
import com.hazelcast.map.impl.operation.steps.DeleteOpSteps;
import com.hazelcast.map.impl.operation.steps.EntryOpSteps;
import com.hazelcast.map.impl.operation.steps.IMapOpStep;
import com.hazelcast.map.impl.operation.steps.PutOpSteps;
import com.hazelcast.map.impl.operation.steps.UtilSteps;
import com.hazelcast.map.impl.operation.steps.engine.State;
import com.hazelcast.map.impl.operation.steps.engine.Step;
import com.hazelcast.map.impl.operation.steps.engine.StepSupplier;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.recordstore.DefaultRecordStore;
import com.hazelcast.map.impl.recordstore.RecordStore;
import com.hazelcast.map.impl.recordstore.Storage;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.impl.IndexRegistry;
import com.hazelcast.query.impl.QueryableEntry;
import com.hazelcast.query.impl.predicates.QueryOptimizer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum PartitionWideEntryOpSteps implements IMapOpStep
{
    PROCESS{

        @Override
        public void runStep(State state) {
            state.setSizeBefore(state.getRecordStore().size());
            if (this.isHDMap(state.getRecordStore()) && !this.isTieredStoreMap(state.getRecordStore()) && this.runWithPartitionedIndex(state)) {
                return;
            }
            this.runWithPartitionScan(state);
        }

        private boolean isHDMap(RecordStore<Record> recordStore) {
            return recordStore.getMapContainer().getMapConfig().getInMemoryFormat() == InMemoryFormat.NATIVE;
        }

        private boolean isTieredStoreMap(RecordStore<Record> recordStore) {
            return recordStore.getMapContainer().getMapConfig().getTieredStoreConfig().isEnabled();
        }

        private boolean runWithPartitionedIndex(State state) {
            Predicate predicate = state.getPredicate();
            RecordStore recordStore = state.getRecordStore();
            MapContainer mapContainer = recordStore.getMapContainer();
            int partitionId = state.getPartitionId();
            MapServiceContext mapServiceContext = mapContainer.getMapServiceContext();
            QueryOptimizer queryOptimizer = mapServiceContext.getQueryOptimizer();
            if (predicate == null) {
                return false;
            }
            IndexRegistry indexRegistry = mapContainer.getOrCreateIndexRegistry(partitionId);
            Iterable<QueryableEntry> entries = indexRegistry.query(queryOptimizer.optimize(predicate, indexRegistry), 1);
            if (entries == null) {
                return false;
            }
            ArrayList<State> toStore = new ArrayList<State>();
            ArrayList<State> toRemove = new ArrayList<State>();
            state.setToStore(toStore);
            state.setToRemove(toRemove);
            MapEntries responses = new MapEntries(recordStore.size());
            state.setResult(responses);
            state.setPredicate(null);
            HashSet keysFromIndex = new HashSet();
            entries.forEach(entry -> {
                keysFromIndex.add(entry.getKeyData());
                Object record = recordStore.getRecord(entry.getKeyData());
                this.processInternal(state, entry.getKeyData(), (Record)record);
            });
            state.setKeysFromIndex(keysFromIndex);
            return true;
        }

        private void runWithPartitionScan(State state) {
            RecordStore recordStore = state.getRecordStore();
            ArrayList<State> toStore = new ArrayList<State>();
            ArrayList<State> toRemove = new ArrayList<State>();
            state.setToStore(toStore);
            state.setToRemove(toRemove);
            MapEntries responses = new MapEntries(recordStore.size());
            state.setResult(responses);
            recordStore.forEach((key, record) -> this.processInternal(state, ToHeapDataConverter.toHeapData(key), (Record)record), false);
        }

        private void processInternal(State state, Data key, Record record) {
            DefaultRecordStore recordStore = (DefaultRecordStore)state.getRecordStore();
            State singleKeyState = new State(state);
            singleKeyState.setKey((Data)recordStore.copyToHeapWhenNeeded(key)).setOldValue(record == null ? null : record.getValue()).setEntryOperator(EntryOperator.operator(state.getOperation(), state.getEntryProcessor(), state.getPredicate()));
            EntryOpSteps.PROCESS.runStep(singleKeyState);
            EntryOpSteps.DO_POST_OPERATE_OPS.runStep(singleKeyState);
            List<State> toStore = state.getToStore();
            List<State> toRemove = state.getToRemove();
            EntryEventType eventType = singleKeyState.getOperator().getEventType();
            if (eventType == null) {
                Data result = singleKeyState.getOperator().getResult();
                if (result != null) {
                    ((MapEntries)state.getResult()).add(singleKeyState.getKey(), result);
                }
            } else {
                switch (eventType) {
                    case ADDED: 
                    case UPDATED: {
                        toStore.add(singleKeyState);
                        break;
                    }
                    case REMOVED: {
                        toRemove.add(singleKeyState);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unexpected event found:" + eventType);
                    }
                }
            }
        }

        @Override
        public Step nextStep(State state) {
            return !state.getToStore().isEmpty() || !state.getToRemove().isEmpty() ? STORE_OR_DELETE : ON_STORE_OR_DELETE;
        }
    }
    ,
    STORE_OR_DELETE{

        @Override
        public boolean isStoreStep() {
            return true;
        }

        @Override
        public void runStep(State state) {
            List<State> toStore = state.getToStore();
            for (State s : toStore) {
                PutOpSteps.STORE.runStep(s);
            }
            List<State> toRemove = state.getToRemove();
            for (State s : toRemove) {
                DeleteOpSteps.DELETE.runStep(s);
            }
        }

        @Override
        public Step nextStep(State state) {
            return ON_STORE_OR_DELETE;
        }
    }
    ,
    ON_STORE_OR_DELETE{

        @Override
        public void runStep(State state) {
            List<State> toStore = state.getToStore();
            for (State s : toStore) {
                PutOpSteps.ON_STORE.runStep(s);
                EntryOperator operator = s.getOperator();
                operator.onAddedOrUpdated0(s.getNewValue());
                operator.doPostOperateOps0();
                Data result = s.getOperator().getResult();
                if (result == null) continue;
                ((MapEntries)state.getResult()).add(s.getKey(), result);
            }
            List<State> toRemove = state.getToRemove();
            for (State s : toRemove) {
                DeleteOpSteps.ON_DELETE.runStep(s);
                EntryOperator operator = s.getOperator();
                operator.onRemove0();
                operator.doPostOperateOps0();
                Data result = s.getOperator().getResult();
                if (result == null) continue;
                ((MapEntries)state.getResult()).add(s.getKey(), result);
            }
        }

        @Override
        public Step nextStep(State state) {
            Storage storage = state.getRecordStore().getStorage();
            state.setSizeAfter(storage.size());
            return StepSupplier.injectCustomStepsToOperation(state.getOperation(), UtilSteps.FINAL_STEP);
        }
    };

}

