/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec.builtin;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.holder.VectorPairHolder;
import com.hazelcast.vector.VectorValues;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class ListMultiFrameCodec {
    private ListMultiFrameCodec() {
    }

    public static <T> void encode(ClientMessage clientMessage, Iterable<T> collection, BiConsumer<ClientMessage, T> encodeFunction) {
        clientMessage.add(ClientMessage.BEGIN_FRAME.copy());
        for (T item : collection) {
            encodeFunction.accept(clientMessage, (ClientMessage)item);
        }
        clientMessage.add(ClientMessage.END_FRAME.copy());
    }

    public static <T> void encodeContainsNullable(ClientMessage clientMessage, Iterable<T> collection, BiConsumer<ClientMessage, T> encodeFunction) {
        clientMessage.add(ClientMessage.BEGIN_FRAME.copy());
        for (T item : collection) {
            if (item == null) {
                clientMessage.add(ClientMessage.NULL_FRAME.copy());
                continue;
            }
            encodeFunction.accept(clientMessage, (ClientMessage)item);
        }
        clientMessage.add(ClientMessage.END_FRAME.copy());
    }

    public static <T> void encodeNullable(ClientMessage clientMessage, Collection<T> collection, BiConsumer<ClientMessage, T> encodeFunction) {
        if (collection == null) {
            clientMessage.add(ClientMessage.NULL_FRAME.copy());
        } else {
            ListMultiFrameCodec.encode(clientMessage, collection, encodeFunction);
        }
    }

    public static <T> List<T> decode(ClientMessage.ForwardFrameIterator iterator, Function<ClientMessage.ForwardFrameIterator, T> decodeFunction) {
        ArrayList<T> result = new ArrayList<T>();
        iterator.next();
        while (!CodecUtil.nextFrameIsDataStructureEndFrame(iterator)) {
            result.add(decodeFunction.apply(iterator));
        }
        iterator.next();
        return result;
    }

    public static <T> List<T> decodeContainsNullable(ClientMessage.ForwardFrameIterator iterator, Function<ClientMessage.ForwardFrameIterator, T> decodeFunction) {
        ArrayList<Object> result = new ArrayList<Object>();
        iterator.next();
        while (!CodecUtil.nextFrameIsDataStructureEndFrame(iterator)) {
            result.add(CodecUtil.nextFrameIsNullEndFrame(iterator) ? null : (Object)decodeFunction.apply(iterator));
        }
        iterator.next();
        return result;
    }

    public static <T> List<T> decodeNullable(ClientMessage.ForwardFrameIterator iterator, Function<ClientMessage.ForwardFrameIterator, T> decodeFunction) {
        return CodecUtil.nextFrameIsNullEndFrame(iterator) ? null : ListMultiFrameCodec.decode(iterator, decodeFunction);
    }

    public static void encode(ClientMessage clientMessage, VectorValues vectors, BiConsumer<ClientMessage, VectorPairHolder> encodeFunction) {
        if (vectors instanceof VectorValues.SingleVectorValues) {
            VectorValues.SingleVectorValues svv = (VectorValues.SingleVectorValues)vectors;
            ListMultiFrameCodec.encode(clientMessage, List.of(new VectorPairHolder("", 0, svv.vector())), encodeFunction);
        } else if (vectors instanceof VectorValues.MultiIndexVectorValues) {
            VectorValues.MultiIndexVectorValues mvv = (VectorValues.MultiIndexVectorValues)vectors;
            List holders = mvv.indexNameToVector().entrySet().stream().map(entry -> new VectorPairHolder((String)entry.getKey(), 0, (float[])entry.getValue())).collect(Collectors.toList());
            ListMultiFrameCodec.encode(clientMessage, holders, encodeFunction);
        }
    }

    public static <T> void encodeNullable(ClientMessage clientMessage, VectorValues collection, BiConsumer<ClientMessage, VectorPairHolder> encodeFunction) {
        if (collection == null) {
            clientMessage.add(ClientMessage.NULL_FRAME.copy());
        } else {
            ListMultiFrameCodec.encode(clientMessage, collection, encodeFunction);
        }
    }
}

