/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.skb.interfaces.transformers;

import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.commons.lang3.Validate;

public interface Transformer<FROM, TO>
extends Function<FROM, TO> {
    default public TO transform(FROM from) {
        Validate.notNull(from);
        return null;
    }

    @Override
    default public TO apply(FROM from) {
        return this.transform(from);
    }

    default public TO transform(FROM from, Predicate<FROM> predicate) {
        Validate.notNull(from);
        Validate.notNull(predicate);
        if (predicate.test(from)) {
            return this.transform(from);
        }
        return null;
    }
}

