/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.skb.interfaces.messagesets;

import de.vandermeer.skb.interfaces.messagesets.IsWarningSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.text.StrBuilder;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;

public interface IsWarningSetFT
extends IsWarningSet<FormattingTuple> {
    default public void addAllWarnings(IsWarningSetFT warnings) {
        this.getWarningMessages().addAll(warnings.getWarningMessages());
    }

    default public void addError(String warning) {
        Validate.notBlank((CharSequence)warning);
        this.addWarning(MessageFormatter.arrayFormat((String)warning, (Object[])new Object[0]));
    }

    default public void addError(String warning, Object ... obj) {
        Validate.notBlank((CharSequence)warning);
        Validate.notNull((Object)obj);
        Validate.noNullElements((Object[])obj);
        this.addWarning(MessageFormatter.arrayFormat((String)warning, (Object[])obj));
    }

    @Override
    default public String render() {
        StrBuilder ret = new StrBuilder(100);
        for (FormattingTuple ft : this.getWarningMessages()) {
            ret.append(ft.getMessage()).appendNewLine();
        }
        return ret.toString();
    }

    public static IsWarningSetFT create() {
        return new IsWarningSetFT(){
            final Set<FormattingTuple> warningSet = new LinkedHashSet<FormattingTuple>();

            @Override
            public Set<FormattingTuple> getWarningMessages() {
                return this.warningSet;
            }
        };
    }
}

