/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.tasks;

import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.opensearch.common.Nullable;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.search.SearchService;
import org.opensearch.tasks.Task;
import org.opensearch.tasks.TaskId;

public abstract class CancellableTask
extends Task {
    private volatile String reason;
    private final AtomicBoolean cancelled = new AtomicBoolean(false);
    private final TimeValue cancelAfterTimeInterval;

    public CancellableTask(long id, String type, String action, String description, TaskId parentTaskId, Map<String, String> headers) {
        this(id, type, action, description, parentTaskId, headers, SearchService.NO_TIMEOUT);
    }

    public CancellableTask(long id, String type, String action, String description, TaskId parentTaskId, Map<String, String> headers, TimeValue cancelAfterTimeInterval) {
        super(id, type, action, description, parentTaskId, headers);
        this.cancelAfterTimeInterval = cancelAfterTimeInterval;
    }

    final void cancel(String reason) {
        assert (reason != null);
        if (this.cancelled.compareAndSet(false, true)) {
            this.reason = reason;
            this.onCancelled();
        }
    }

    public boolean cancelOnParentLeaving() {
        return true;
    }

    public abstract boolean shouldCancelChildrenOnCancellation();

    public boolean isCancelled() {
        return this.cancelled.get();
    }

    public TimeValue getCancellationTimeout() {
        return this.cancelAfterTimeInterval;
    }

    @Nullable
    public final String getReasonCancelled() {
        return this.reason;
    }

    protected void onCancelled() {
    }
}

