/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action.admin.cluster.dangling;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.opensearch.action.ActionListener;
import org.opensearch.action.admin.indices.dangling.import_index.ImportDanglingIndexRequest;
import org.opensearch.action.support.master.AcknowledgedResponse;
import org.opensearch.client.node.NodeClient;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestStatus;
import org.opensearch.rest.action.RestToXContentListener;

public class RestImportDanglingIndexAction
extends BaseRestHandler {
    @Override
    public List<RestHandler.Route> routes() {
        return Collections.singletonList(new RestHandler.Route(RestRequest.Method.POST, "/_dangling/{index_uuid}"));
    }

    @Override
    public String getName() {
        return "import_dangling_index";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        ImportDanglingIndexRequest importRequest = new ImportDanglingIndexRequest(request.param("index_uuid"), request.paramAsBoolean("accept_data_loss", false));
        importRequest.timeout(request.paramAsTime("timeout", importRequest.timeout()));
        importRequest.masterNodeTimeout(request.paramAsTime("master_timeout", importRequest.masterNodeTimeout()));
        return channel -> client.admin().cluster().importDanglingIndex(importRequest, (ActionListener<AcknowledgedResponse>)new RestToXContentListener<AcknowledgedResponse>(channel){

            @Override
            protected RestStatus getStatus(AcknowledgedResponse acknowledgedResponse) {
                return RestStatus.ACCEPTED;
            }
        });
    }
}

