/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.fielddata;

import java.io.IOException;
import org.apache.lucene.util.Accountable;
import org.opensearch.common.lease.Releasable;
import org.opensearch.index.fielddata.ScriptDocValues;
import org.opensearch.index.fielddata.SortedBinaryDocValues;
import org.opensearch.index.mapper.DocValueFetcher;
import org.opensearch.search.DocValueFormat;

public interface LeafFieldData
extends Accountable,
Releasable {
    public ScriptDocValues<?> getScriptValues();

    public SortedBinaryDocValues getBytesValues();

    default public DocValueFetcher.Leaf getLeafValueFetcher(final DocValueFormat format) {
        final SortedBinaryDocValues values = this.getBytesValues();
        return new DocValueFetcher.Leaf(){

            @Override
            public boolean advanceExact(int docId) throws IOException {
                return values.advanceExact(docId);
            }

            @Override
            public int docValueCount() throws IOException {
                return values.docValueCount();
            }

            @Override
            public Object nextValue() throws IOException {
                return format.format(values.nextValue());
            }
        };
    }
}

