/*
 * Decompiled with CFR 0.152.
 */
package org.archive.util.iterator;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.archive.util.StringFieldExtractor;
import org.archive.util.iterator.StringFilter;

public class FilterStringIterator
implements Iterator<String> {
    private static final Logger LOGGER = Logger.getLogger(FilterStringIterator.class.getName());
    private static final int DEFAULT_FIELD = 0;
    private static final char DEFAULT_DELIM = ' ';
    private int field = 0;
    private char delim = (char)32;
    private StringFilter filter;
    private Iterator<String> wrapped;
    private StringFieldExtractor extractor;
    private String cachedNext;

    public FilterStringIterator(Iterator<String> wrapped, StringFilter filter) {
        this.wrapped = wrapped;
        this.filter = filter;
        this.cachedNext = null;
        this.extractor = new StringFieldExtractor(this.delim, this.field);
    }

    public int getField() {
        return this.field;
    }

    public void setField(int field) {
        this.field = field;
        this.extractor = new StringFieldExtractor(this.delim, field);
    }

    public char getDelim() {
        return this.delim;
    }

    public void setDelim(char delim) {
        this.delim = delim;
        this.extractor = new StringFieldExtractor(delim, this.field);
    }

    @Override
    public boolean hasNext() {
        String tmp;
        if (this.cachedNext != null) {
            return true;
        }
        while (true) {
            if (!this.wrapped.hasNext()) {
                return false;
            }
            tmp = this.wrapped.next();
            String f = this.extractor.extract(tmp);
            if (!this.filter.isFiltered(f)) break;
            if (!LOGGER.isLoggable(Level.FINE)) continue;
            LOGGER.fine("Filtered:" + f);
        }
        this.cachedNext = tmp;
        return true;
    }

    @Override
    public String next() {
        if (this.cachedNext == null) {
            throw new NoSuchElementException("Call hasNext() first");
        }
        String tmp = this.cachedNext;
        this.cachedNext = null;
        return tmp;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

