/*
 * Decompiled with CFR 0.152.
 */
package org.archive.util.io;

import java.io.IOException;
import java.io.InputStream;
import org.archive.util.io.BytesReadObserver;

public class NotifyingInputStream
extends InputStream {
    InputStream wrapped;
    BytesReadObserver observer;

    public NotifyingInputStream(InputStream wrapped, BytesReadObserver observer) {
        this.wrapped = wrapped;
        this.observer = observer;
    }

    private int notifyRead(int amt) {
        if (amt > 0) {
            this.observer.notifyBytesRead(amt);
        }
        return amt;
    }

    @Override
    public int read() throws IOException {
        return this.notifyRead(this.wrapped.read());
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.notifyRead(this.wrapped.read(b));
    }

    @Override
    public int read(byte[] b, int o, int l) throws IOException {
        return this.notifyRead(this.wrapped.read(b, o, l));
    }
}

