/*
 * Decompiled with CFR 0.152.
 */
package org.archive.util.binsearch.impl;

import java.io.IOException;
import org.archive.util.binsearch.AbstractSeekableLineReader;

public abstract class HTTPSeekableLineReader
extends AbstractSeekableLineReader {
    public static final String CONTENT_LENGTH = "Content-Length";
    public static final String LAST_MODIFIED = "Last-Modified";
    protected boolean noKeepAlive;
    protected String cookie;
    protected String connectedUrl;
    protected String errHeader;
    protected String saveErrHeader;

    public abstract String getUrl();

    @Override
    public abstract long getSize() throws IOException;

    public abstract String getHeaderValue(String var1);

    public static String makeRangeHeader(long offset, int maxLength) {
        StringBuilder builder = new StringBuilder(32);
        builder.append("bytes=");
        builder.append(offset);
        builder.append('-');
        long endOffset = -1L;
        if (maxLength > 0) {
            endOffset = offset + (long)maxLength - 1L;
            builder.append(endOffset);
        }
        return builder.toString();
    }

    public String getCookie() {
        return this.cookie;
    }

    public void setCookie(String cookie) {
        this.cookie = cookie;
    }

    public boolean isNoKeepAlive() {
        return this.noKeepAlive;
    }

    public void setNoKeepAlive(boolean noKeepAlive) {
        this.noKeepAlive = noKeepAlive;
    }

    public String getConnectedUrl() {
        return this.connectedUrl;
    }

    public String getSaveErrHeader() {
        return this.saveErrHeader;
    }

    public void setSaveErrHeader(String saveErrHeader) {
        this.saveErrHeader = saveErrHeader;
    }

    public String getErrHeader() {
        return this.errHeader;
    }

    public void setErrHeader(String errHeader) {
        this.errHeader = errHeader;
    }

    public static class BadHttpStatusException
    extends IOException {
        private static final long serialVersionUID = 1L;
        int status;

        public BadHttpStatusException(int status, String details) {
            super("Http Status " + status + " returned: " + details);
            this.status = status;
        }

        public int getStatus() {
            return this.status;
        }
    }
}

