/*
 * Decompiled with CFR 0.152.
 */
package org.archive.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.archive.util.io.PushBackOneByteInputStream;

public class StreamCopy {
    private static final int DEFAULT_READ_SIZE = 4096;

    public static long copy(InputStream i, OutputStream o) throws IOException {
        return StreamCopy.copy(i, o, 4096);
    }

    public static long copy(InputStream i, OutputStream o, int bytes) throws IOException {
        long total = 0L;
        byte[] buf = new byte[bytes];
        int amt = 1;
        while (amt != -1) {
            amt = i.read(buf, 0, bytes);
            if (amt <= 0) continue;
            o.write(buf, 0, amt);
            total += (long)amt;
        }
        return total;
    }

    public static long copyLength(InputStream i, OutputStream o, long bytes) throws IOException {
        return StreamCopy.copyLength(i, o, 4096L);
    }

    public static long copyLength(InputStream i, OutputStream o, long bytes, int readSize) throws IOException {
        long total = 0L;
        byte[] buf = new byte[readSize];
        while (bytes > 0L) {
            int amtToRead = (int)Math.min(bytes, (long)readSize);
            int amtRead = i.read(buf, 0, amtToRead);
            if (amtRead == -1) {
                return total;
            }
            if (amtRead <= 0) continue;
            o.write(buf, 0, amtRead);
            total += (long)amtRead;
        }
        return total;
    }

    public static long readToEOF(InputStream i) throws IOException {
        return StreamCopy.readToEOF(i, 4096);
    }

    public static long readToEOF(InputStream i, int bufferSize) throws IOException {
        long numBytes = 0L;
        byte[] buffer = new byte[bufferSize];
        int amt;
        while ((amt = i.read(buffer, 0, bufferSize)) != -1) {
            numBytes += (long)amt;
        }
        return numBytes;
    }

    public static long readToEOFSingle(InputStream i) throws IOException {
        long numBytes = 0L;
        int c;
        while ((c = i.read()) != -1) {
            ++numBytes;
        }
        return numBytes;
    }

    public static long skipChars(PushBackOneByteInputStream i, int[] skips) throws IOException {
        int b;
        long numBytes = 0L;
        while ((b = i.read()) != -1) {
            boolean pushBack = true;
            for (int c : skips) {
                if (b != c) continue;
                pushBack = false;
                break;
            }
            if (pushBack) {
                i.pushback();
                break;
            }
            ++numBytes;
        }
        return numBytes;
    }
}

