/*
 * Decompiled with CFR 0.152.
 */
package org.archive.httpclient;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.logging.Logger;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class ConfigurableX509TrustManager
implements X509TrustManager {
    protected static Logger logger = Logger.getLogger("org.archive.httpclient.ConfigurableX509TrustManager");
    public static final TrustLevel DEFAULT = TrustLevel.OPEN;
    private TrustLevel trustLevel = DEFAULT;
    private X509TrustManager standardTrustManager = null;

    public ConfigurableX509TrustManager() throws NoSuchAlgorithmException, KeyStoreException {
        this(DEFAULT);
    }

    public ConfigurableX509TrustManager(TrustLevel level) throws NoSuchAlgorithmException, KeyStoreException {
        TrustManagerFactory factory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        factory.init((KeyStore)null);
        TrustManager[] trustmanagers = factory.getTrustManagers();
        if (trustmanagers.length == 0) {
            throw new NoSuchAlgorithmException(TrustManagerFactory.getDefaultAlgorithm() + " trust manager not supported");
        }
        this.standardTrustManager = (X509TrustManager)trustmanagers[0];
        this.trustLevel = level;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] certificates, String type) throws CertificateException {
        if (this.trustLevel.equals((Object)TrustLevel.OPEN)) {
            return;
        }
        this.standardTrustManager.checkClientTrusted(certificates, type);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] certificates, String type) throws CertificateException {
        if (this.trustLevel.equals((Object)TrustLevel.OPEN)) {
            return;
        }
        try {
            this.standardTrustManager.checkServerTrusted(certificates, type);
            if (this.trustLevel.equals((Object)TrustLevel.STRICT)) {
                logger.severe((Object)((Object)TrustLevel.STRICT) + " not implemented.");
            }
        }
        catch (CertificateException e) {
            if (this.trustLevel.equals((Object)TrustLevel.LOOSE) && certificates != null && certificates.length == 1) {
                X509Certificate certificate = certificates[0];
                certificate.checkValidity();
            }
            throw e;
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.standardTrustManager.getAcceptedIssuers();
    }

    public static enum TrustLevel {
        OPEN,
        LOOSE,
        NORMAL,
        STRICT;

    }
}

