/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import kafka.controller.ControllerEvent;
import kafka.controller.ControllerEventManager$;
import kafka.controller.ControllerEventProcessor;
import kafka.controller.ControllerState;
import kafka.controller.ControllerState$Idle$;
import kafka.controller.QueuedEvent;
import kafka.controller.ShutdownEventThread$;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import org.apache.kafka.server.util.ShutdownableThread;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005]x!\u0002\u0016,\u0011\u0003\u0001d!\u0002\u001a,\u0011\u0003\u0019\u0004\"\u0002\u001e\u0002\t\u0003Y\u0004b\u0002\u001f\u0002\u0005\u0004%\t!\u0010\u0005\u0007\r\u0006\u0001\u000b\u0011\u0002 \t\u000f\u001d\u000b!\u0019!C\u0001{!1\u0001*\u0001Q\u0001\nyBq!S\u0001C\u0002\u0013\u0005Q\b\u0003\u0004K\u0003\u0001\u0006IA\u0010\u0005\b\u0017\u0006\t\n\u0011\"\u0001M\r\u0011\u00114\u0006\u0001.\t\u0011mS!\u0011!Q\u0001\nqC\u0001b\u0018\u0006\u0003\u0002\u0003\u0006I\u0001\u0019\u0005\tG*\u0011\t\u0011)A\u0005I\"A\u0011O\u0003B\u0001B\u0003%!\u000fC\u0005\u0002\u0010)\u0011\t\u0011)A\u0005\u001d\"1!H\u0003C\u0001\u0003#A\u0011\"a\b\u000b\u0005\u0004%I!!\t\t\u0011\u0005E\"\u0002)A\u0005\u0003GA\u0011\"a\r\u000b\u0001\u0004%I!!\u000e\t\u0013\u0005]\"\u00021A\u0005\n\u0005e\u0002bBA#\u0015\u0001\u0006K\u0001\u001f\u0005\n\u0003\u001fR!\u0019!C\u0005\u0003#B\u0001\"a\u001a\u000bA\u0003%\u00111\u000b\u0005\n\u0003SR!\u0019!C\u0005\u0003WB\u0001\"a\u001f\u000bA\u0003%\u0011Q\u000e\u0005\u000b\u0003{R\u0001\u0019!C\u0001W\u0005}\u0004BCA^\u0015\u0001\u0007I\u0011A\u0016\u0002>\"A\u0011\u0011\u0019\u0006!B\u0013\t\t\tC\u0005\u0002D*\u0011\r\u0011\"\u0003\u0002F\"A\u0011Q\u001a\u0006!\u0002\u0013\t9\rC\u0004\u0002P*!\t!!\u000e\t\u000f\u0005E'\u0002\"\u0001\u0002:\"9\u00111\u001b\u0006\u0005\u0002\u0005e\u0006bBAk\u0015\u0011\u0005\u0011q\u001b\u0005\b\u0003GTA\u0011AAs\u0011\u001d\tIO\u0003C\u0001\u0003W4a!!\"\u000b\u0001\u0005\u001d\u0005BCAOK\t\u0005\t\u0015!\u0003\u0002 \"1!(\nC\u0001\u0003gCq!a.&\t\u0003\nI\fC\u0004\u0002t*!I!!>\u0002-\r{g\u000e\u001e:pY2,'/\u0012<f]Rl\u0015M\\1hKJT!\u0001L\u0017\u0002\u0015\r|g\u000e\u001e:pY2,'OC\u0001/\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0001\"!M\u0001\u000e\u0003-\u0012acQ8oiJ|G\u000e\\3s\u000bZ,g\u000e^'b]\u0006<WM]\n\u0003\u0003Q\u0002\"!\u000e\u001d\u000e\u0003YR\u0011aN\u0001\u0006g\u000e\fG.Y\u0005\u0003sY\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u00011\u0003e\u0019uN\u001c;s_2dWM]#wK:$H\u000b\u001b:fC\u0012t\u0015-\\3\u0016\u0003y\u0002\"a\u0010#\u000e\u0003\u0001S!!\u0011\"\u0002\t1\fgn\u001a\u0006\u0002\u0007\u0006!!.\u0019<b\u0013\t)\u0005I\u0001\u0004TiJLgnZ\u0001\u001b\u0007>tGO]8mY\u0016\u0014XI^3oiRC'/Z1e\u001d\u0006lW\rI\u0001\u0019\u000bZ,g\u000e^)vKV,G+[7f\u001b\u0016$(/[2OC6,\u0017!G#wK:$\u0018+^3vKRKW.Z'fiJL7MT1nK\u0002\n\u0001$\u0012<f]R\fV/Z;f'&TX-T3ue&\u001cg*Y7f\u0003e)e/\u001a8u#V,W/Z*ju\u0016lU\r\u001e:jG:\u000bW.\u001a\u0011\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00136+\u0005i%F\u0001(R!\t)t*\u0003\u0002Qm\t!Aj\u001c8hW\u0005\u0011\u0006CA*Y\u001b\u0005!&BA+W\u0003%)hn\u00195fG.,GM\u0003\u0002Xm\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005e#&!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dKN\u0011!\u0002N\u0001\rG>tGO]8mY\u0016\u0014\u0018\n\u001a\t\u0003kuK!A\u0018\u001c\u0003\u0007%sG/A\u0005qe>\u001cWm]:peB\u0011\u0011'Y\u0005\u0003E.\u0012\u0001dQ8oiJ|G\u000e\\3s\u000bZ,g\u000e\u001e)s_\u000e,7o]8s\u0003\u0011!\u0018.\\3\u0011\u0005\u0015|W\"\u00014\u000b\u0005\u001dD\u0017!B;uS2\u001c(BA5k\u0003\u0019\u0019w.\\7p]*\u0011af\u001b\u0006\u0003Y6\fa!\u00199bG\",'\"\u00018\u0002\u0007=\u0014x-\u0003\u0002qM\n!A+[7f\u0003I\u0011\u0018\r^3B]\u0012$\u0016.\\3NKR\u0014\u0018nY:\u0011\tM4\bp_\u0007\u0002i*\u0011QON\u0001\u000bG>dG.Z2uS>t\u0017BA<u\u0005\ri\u0015\r\u001d\t\u0003ceL!A_\u0016\u0003\u001f\r{g\u000e\u001e:pY2,'o\u0015;bi\u0016\u00042\u0001`A\u0006\u001b\u0005i(B\u0001@\u0000\u0003\u0011\u0019wN]3\u000b\t\u0005\u0005\u00111A\u0001\b[\u0016$(/[2t\u0015\u0011\t)!a\u0002\u0002\re\fW.\\3s\u0015\t\tI!A\u0002d_6L1!!\u0004~\u0005\u0015!\u0016.\\3s\u0003])g/\u001a8u#V,W/\u001a+j[\u0016$\u0016.\\3pkRl5\u000f\u0006\u0007\u0002\u0014\u0005U\u0011qCA\r\u00037\ti\u0002\u0005\u00022\u0015!)1\f\u0005a\u00019\")q\f\u0005a\u0001A\")1\r\u0005a\u0001I\")\u0011\u000f\u0005a\u0001e\"A\u0011q\u0002\t\u0011\u0002\u0003\u0007a*\u0001\u0007nKR\u0014\u0018nY:He>,\b/\u0006\u0002\u0002$A!\u0011QEA\u0017\u001b\t\t9C\u0003\u0003\u0002\u0002\u0005%\"bAA\u0016U\u000611/\u001a:wKJLA!a\f\u0002(\t\t2*\u00194lC6+GO]5dg\u001e\u0013x.\u001e9\u0002\u001b5,GO]5dg\u001e\u0013x.\u001e9!\u0003\u0019y6\u000f^1uKV\t\u00010\u0001\u0006`gR\fG/Z0%KF$B!a\u000f\u0002BA\u0019Q'!\u0010\n\u0007\u0005}bG\u0001\u0003V]&$\b\u0002CA\")\u0005\u0005\t\u0019\u0001=\u0002\u0007a$\u0013'A\u0004`gR\fG/\u001a\u0011)\u0007U\tI\u0005E\u00026\u0003\u0017J1!!\u00147\u0005!1x\u000e\\1uS2,\u0017a\u00029vi2{7m[\u000b\u0003\u0003'\u0002B!!\u0016\u0002d5\u0011\u0011q\u000b\u0006\u0005\u00033\nY&A\u0003m_\u000e\\7O\u0003\u0003\u0002^\u0005}\u0013AC2p]\u000e,(O]3oi*\u0019\u0011\u0011\r\"\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003K\n9FA\u0007SK\u0016tGO]1oi2{7m[\u0001\taV$Hj\\2lA\u0005)\u0011/^3vKV\u0011\u0011Q\u000e\t\u0007\u0003_\n\t(!\u001e\u000e\u0005\u0005m\u0013\u0002BA:\u00037\u00121\u0003T5oW\u0016$'\t\\8dW&tw-U;fk\u0016\u00042!MA<\u0013\r\tIh\u000b\u0002\f#V,W/\u001a3Fm\u0016tG/\u0001\u0004rk\u0016,X\rI\u0001\u0007i\"\u0014X-\u00193\u0016\u0005\u0005\u0005\u0005cAABK5\t!BA\u000bD_:$(o\u001c7mKJ,e/\u001a8u)\"\u0014X-\u00193\u0014\u000b\u0015\nI)a%\u0011\t\u0005-\u0015qR\u0007\u0003\u0003\u001bSA!!\u0019\u0002*%!\u0011\u0011SAG\u0005I\u0019\u0006.\u001e;e_^t\u0017M\u00197f)\"\u0014X-\u00193\u0011\t\u0005U\u0015\u0011T\u0007\u0003\u0003/S!aZ\u0017\n\t\u0005m\u0015q\u0013\u0002\b\u0019><w-\u001b8h\u0003\u0011q\u0017-\\3\u0011\t\u0005\u0005\u0016q\u0016\b\u0005\u0003G\u000bY\u000bE\u0002\u0002&Zj!!a*\u000b\u0007\u0005%v&\u0001\u0004=e>|GOP\u0005\u0004\u0003[3\u0014A\u0002)sK\u0012,g-C\u0002F\u0003cS1!!,7)\u0011\t\t)!.\t\u000f\u0005uu\u00051\u0001\u0002 \u00061Am\\,pe.$\"!a\u000f\u0002\u0015QD'/Z1e?\u0012*\u0017\u000f\u0006\u0003\u0002<\u0005}\u0006\"CA\"7\u0005\u0005\t\u0019AAA\u0003\u001d!\bN]3bI\u0002\n!#\u001a<f]R\fV/Z;f)&lW\rS5tiV\u0011\u0011q\u0019\t\u0004y\u0006%\u0017bAAf{\nI\u0001*[:u_\u001e\u0014\u0018-\\\u0001\u0014KZ,g\u000e^)vKV,G+[7f\u0011&\u001cH\u000fI\u0001\u0006gR\fG/Z\u0001\u0006gR\f'\u000f^\u0001\u0006G2|7/Z\u0001\u0004aV$H\u0003BA;\u00033Dq!a7#\u0001\u0004\ti.A\u0003fm\u0016tG\u000fE\u00022\u0003?L1!!9,\u0005=\u0019uN\u001c;s_2dWM]#wK:$\u0018aC2mK\u0006\u0014\u0018I\u001c3QkR$B!!\u001e\u0002h\"9\u00111\\\u0012A\u0002\u0005u\u0017aB5t\u000b6\u0004H/_\u000b\u0003\u0003[\u00042!NAx\u0013\r\t\tP\u000e\u0002\b\u0005>|G.Z1o\u0003I\u0001x\u000e\u001c7Ge>lWI^3oiF+X-^3\u0015\u0005\u0005U\u0004")
public class ControllerEventManager {
    public final int kafka$controller$ControllerEventManager$$controllerId;
    public final ControllerEventProcessor kafka$controller$ControllerEventManager$$processor;
    public final Time kafka$controller$ControllerEventManager$$time;
    public final Map<ControllerState, Timer> kafka$controller$ControllerEventManager$$rateAndTimeMetrics;
    private final long eventQueueTimeTimeoutMs;
    private final KafkaMetricsGroup metricsGroup;
    private volatile ControllerState kafka$controller$ControllerEventManager$$_state;
    private final ReentrantLock putLock;
    private final LinkedBlockingQueue<QueuedEvent> queue;
    private ControllerEventThread thread;
    private final Histogram kafka$controller$ControllerEventManager$$eventQueueTimeHist;

    public static long $lessinit$greater$default$5() {
        return ControllerEventManager$.MODULE$.$lessinit$greater$default$5();
    }

    public static String EventQueueSizeMetricName() {
        return ControllerEventManager$.MODULE$.EventQueueSizeMetricName();
    }

    public static String EventQueueTimeMetricName() {
        return ControllerEventManager$.MODULE$.EventQueueTimeMetricName();
    }

    public static String ControllerEventThreadName() {
        return ControllerEventManager$.MODULE$.ControllerEventThreadName();
    }

    private KafkaMetricsGroup metricsGroup() {
        return this.metricsGroup;
    }

    private ControllerState kafka$controller$ControllerEventManager$$_state() {
        return this.kafka$controller$ControllerEventManager$$_state;
    }

    public void kafka$controller$ControllerEventManager$$_state_$eq(ControllerState x$1) {
        this.kafka$controller$ControllerEventManager$$_state = x$1;
    }

    private ReentrantLock putLock() {
        return this.putLock;
    }

    private LinkedBlockingQueue<QueuedEvent> queue() {
        return this.queue;
    }

    public ControllerEventThread thread() {
        return this.thread;
    }

    public void thread_$eq(ControllerEventThread x$1) {
        this.thread = x$1;
    }

    public Histogram kafka$controller$ControllerEventManager$$eventQueueTimeHist() {
        return this.kafka$controller$ControllerEventManager$$eventQueueTimeHist;
    }

    public ControllerState state() {
        return this.kafka$controller$ControllerEventManager$$_state();
    }

    public void start() {
        this.thread().start();
    }

    public void close() {
        try {
            this.thread().initiateShutdown();
            this.clearAndPut(ShutdownEventThread$.MODULE$);
            this.thread().awaitShutdown();
        }
        finally {
            this.metricsGroup().removeMetric(ControllerEventManager$.MODULE$.EventQueueTimeMetricName());
            this.metricsGroup().removeMetric(ControllerEventManager$.MODULE$.EventQueueSizeMetricName());
        }
    }

    /*
     * WARNING - void declaration
     */
    public QueuedEvent put(ControllerEvent event) {
        QueuedEvent queuedEvent;
        void inLock_lock;
        ReentrantLock reentrantLock = this.putLock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            queuedEvent = ControllerEventManager.$anonfun$put$1(this, event);
        }
        finally {
            inLock_lock.unlock();
        }
        return queuedEvent;
    }

    /*
     * WARNING - void declaration
     */
    public QueuedEvent clearAndPut(ControllerEvent event) {
        QueuedEvent queuedEvent;
        void inLock_lock;
        ReentrantLock reentrantLock = this.putLock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            queuedEvent = ControllerEventManager.$anonfun$clearAndPut$1(this, event);
        }
        finally {
            inLock_lock.unlock();
        }
        return queuedEvent;
    }

    public boolean isEmpty() {
        return this.queue().isEmpty();
    }

    public QueuedEvent kafka$controller$ControllerEventManager$$pollFromEventQueue() {
        if (this.kafka$controller$ControllerEventManager$$eventQueueTimeHist().count() != 0L) {
            QueuedEvent event = this.queue().poll(this.eventQueueTimeTimeoutMs, TimeUnit.MILLISECONDS);
            if (event == null) {
                this.kafka$controller$ControllerEventManager$$eventQueueTimeHist().clear();
                return this.queue().take();
            }
            return event;
        }
        return this.queue().take();
    }

    public final /* synthetic */ int kafka$controller$ControllerEventManager$$$anonfun$new$1() {
        return this.queue().size();
    }

    public static final /* synthetic */ QueuedEvent $anonfun$put$1(ControllerEventManager $this, ControllerEvent event$1) {
        QueuedEvent queuedEvent = new QueuedEvent(event$1, $this.kafka$controller$ControllerEventManager$$time.milliseconds());
        $this.queue().put(queuedEvent);
        return queuedEvent;
    }

    public static final /* synthetic */ QueuedEvent $anonfun$clearAndPut$1(ControllerEventManager $this, ControllerEvent event$2) {
        ArrayList<QueuedEvent> preemptedEvents = new ArrayList<QueuedEvent>();
        $this.queue().drainTo(preemptedEvents);
        preemptedEvents.forEach(x$1 -> x$1.preempt($this.kafka$controller$ControllerEventManager$$processor));
        return $this.put(event$2);
    }

    public ControllerEventManager(int controllerId, ControllerEventProcessor processor, Time time, Map<ControllerState, Timer> rateAndTimeMetrics, long eventQueueTimeTimeoutMs) {
        this.kafka$controller$ControllerEventManager$$controllerId = controllerId;
        this.kafka$controller$ControllerEventManager$$processor = processor;
        this.kafka$controller$ControllerEventManager$$time = time;
        this.kafka$controller$ControllerEventManager$$rateAndTimeMetrics = rateAndTimeMetrics;
        this.eventQueueTimeTimeoutMs = eventQueueTimeTimeoutMs;
        this.metricsGroup = new KafkaMetricsGroup(this.getClass());
        this.kafka$controller$ControllerEventManager$$_state = ControllerState$Idle$.MODULE$;
        this.putLock = new ReentrantLock();
        this.queue = new LinkedBlockingQueue();
        this.thread = new ControllerEventThread(ControllerEventManager$.MODULE$.ControllerEventThreadName());
        this.kafka$controller$ControllerEventManager$$eventQueueTimeHist = this.metricsGroup().newHistogram(ControllerEventManager$.MODULE$.EventQueueTimeMetricName());
        this.metricsGroup().newGauge(ControllerEventManager$.MODULE$.EventQueueSizeMetricName(), (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ ControllerEventManager $outer;

            public final int value() {
                return this.$outer.kafka$controller$ControllerEventManager$$$anonfun$new$1();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public class ControllerEventThread
    extends ShutdownableThread
    implements Logging {
        private Logger logger;
        private String logIdent;
        private volatile boolean bitmap$0;

        @Override
        public String loggerName() {
            return Logging.loggerName$(this);
        }

        @Override
        public String msgWithLogIdent(String msg) {
            return Logging.msgWithLogIdent$(this, msg);
        }

        @Override
        public void trace(Function0<String> msg) {
            Logging.trace$(this, msg);
        }

        @Override
        public void trace(Function0<String> msg, Function0<Throwable> e) {
            Logging.trace$(this, msg, e);
        }

        @Override
        public boolean isDebugEnabled() {
            return Logging.isDebugEnabled$(this);
        }

        @Override
        public boolean isTraceEnabled() {
            return Logging.isTraceEnabled$(this);
        }

        @Override
        public void debug(Function0<String> msg) {
            Logging.debug$(this, msg);
        }

        @Override
        public void debug(Function0<String> msg, Function0<Throwable> e) {
            Logging.debug$(this, msg, e);
        }

        @Override
        public void info(Function0<String> msg) {
            Logging.info$(this, msg);
        }

        @Override
        public void info(Function0<String> msg, Function0<Throwable> e) {
            Logging.info$(this, msg, e);
        }

        @Override
        public void warn(Function0<String> msg) {
            Logging.warn$(this, msg);
        }

        @Override
        public void warn(Function0<String> msg, Function0<Throwable> e) {
            Logging.warn$(this, msg, e);
        }

        @Override
        public void error(Function0<String> msg) {
            Logging.error$(this, msg);
        }

        @Override
        public void error(Function0<String> msg, Function0<Throwable> e) {
            Logging.error$(this, msg, e);
        }

        @Override
        public void fatal(Function0<String> msg) {
            Logging.fatal$(this, msg);
        }

        @Override
        public void fatal(Function0<String> msg, Function0<Throwable> e) {
            Logging.fatal$(this, msg, e);
        }

        private Logger logger$lzycompute() {
            synchronized (this) {
                if (!this.bitmap$0) {
                    this.logger = Logging.logger$(this);
                    this.bitmap$0 = true;
                }
            }
            return this.logger;
        }

        @Override
        public Logger logger() {
            if (!this.bitmap$0) {
                return this.logger$lzycompute();
            }
            return this.logger;
        }

        @Override
        public String logIdent() {
            return this.logIdent;
        }

        @Override
        public void logIdent_$eq(String x$1) {
            this.logIdent = x$1;
        }

        public void doWork() {
            block5: {
                QueuedEvent dequeued = this.kafka$controller$ControllerEventManager$ControllerEventThread$$$outer().kafka$controller$ControllerEventManager$$pollFromEventQueue();
                ControllerEvent controllerEvent = dequeued.event();
                if (ShutdownEventThread$.MODULE$.equals(controllerEvent)) {
                    return;
                }
                this.kafka$controller$ControllerEventManager$ControllerEventThread$$$outer().kafka$controller$ControllerEventManager$$_state_$eq(controllerEvent.state());
                this.kafka$controller$ControllerEventManager$ControllerEventThread$$$outer().kafka$controller$ControllerEventManager$$eventQueueTimeHist().update(this.kafka$controller$ControllerEventManager$ControllerEventThread$$$outer().kafka$controller$ControllerEventManager$$time.milliseconds() - dequeued.enqueueTimeMs());
                try {
                    Option option = this.kafka$controller$ControllerEventManager$ControllerEventThread$$$outer().kafka$controller$ControllerEventManager$$rateAndTimeMetrics.get((Object)this.kafka$controller$ControllerEventManager$ControllerEventThread$$$outer().state());
                    if (option instanceof Some) {
                        BoxedUnit cfr_ignored_0 = (BoxedUnit)((Timer)((Some)option).value()).time(() -> {
                            this.process$1(dequeued);
                            return BoxedUnit.UNIT;
                        });
                        break block5;
                    }
                    if (None$.MODULE$.equals(option)) {
                        this.process$1(dequeued);
                        break block5;
                    }
                    throw new MatchError((Object)option);
                }
                catch (Throwable e) {
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Uncaught error processing event ").append(controllerEvent).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                }
            }
            this.kafka$controller$ControllerEventManager$ControllerEventThread$$$outer().kafka$controller$ControllerEventManager$$_state_$eq(ControllerState$Idle$.MODULE$);
        }

        public /* synthetic */ ControllerEventManager kafka$controller$ControllerEventManager$ControllerEventThread$$$outer() {
            return ControllerEventManager.this;
        }

        private final void process$1(QueuedEvent dequeued$1) {
            dequeued$1.process(this.kafka$controller$ControllerEventManager$ControllerEventThread$$$outer().kafka$controller$ControllerEventManager$$processor);
        }

        public ControllerEventThread(String name) {
            if (ControllerEventManager.this == null) {
                throw null;
            }
            super(name, false, new StringBuilder(38).append("[ControllerEventThread controllerId=").append(ControllerEventManager.this.kafka$controller$ControllerEventManager$$controllerId).append("] ").toString());
            Logging.$init$(this);
            this.logIdent_$eq(this.logPrefix);
        }
    }
}

