/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.parse.tika;

import de.l3s.boilerpipe.BoilerpipeExtractor;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BoilerpipeExtractorRepository {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final HashMap<String, BoilerpipeExtractor> extractorRepository = new HashMap();

    BoilerpipeExtractorRepository() {
    }

    public static synchronized BoilerpipeExtractor getExtractor(String boilerpipeExtractorName) {
        if (!extractorRepository.containsKey(boilerpipeExtractorName)) {
            boilerpipeExtractorName = "de.l3s.boilerpipe.extractors." + (String)boilerpipeExtractorName;
            try {
                ClassLoader loader = BoilerpipeExtractor.class.getClassLoader();
                Class<?> extractorClass = loader.loadClass((String)boilerpipeExtractorName);
                extractorRepository.put((String)boilerpipeExtractorName, (BoilerpipeExtractor)extractorClass.getConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (ClassNotFoundException e) {
                LOG.error("BoilerpipeExtractor {} not found!", boilerpipeExtractorName);
            }
            catch (InstantiationException e) {
                LOG.error("Could not instantiate {}", boilerpipeExtractorName);
            }
            catch (Exception e) {
                LOG.error(e.getMessage());
            }
        }
        return extractorRepository.get(boilerpipeExtractorName);
    }
}

