/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.migration;

import java.util.Optional;
import org.apache.kafka.common.metadata.ZkMigrationStateRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.server.common.ApiMessageAndVersion;

public enum ZkMigrationState {
    NONE(0),
    PRE_MIGRATION(2),
    MIGRATION(1),
    POST_MIGRATION(3),
    ZK(4);

    private final byte value;

    private ZkMigrationState(byte value) {
        this.value = value;
    }

    public byte value() {
        return this.value;
    }

    public ApiMessageAndVersion toRecord() {
        return new ApiMessageAndVersion((ApiMessage)new ZkMigrationStateRecord().setZkMigrationState(this.value()), 0);
    }

    public static ZkMigrationState of(byte value) {
        return ZkMigrationState.optionalOf(value).orElseThrow(() -> new IllegalArgumentException(String.format("Value %s is not a valid Zk migration state", value)));
    }

    public static Optional<ZkMigrationState> optionalOf(byte value) {
        for (ZkMigrationState state : ZkMigrationState.values()) {
            if (state.value != value) continue;
            return Optional.of(state);
        }
        return Optional.empty();
    }

    public boolean inProgress() {
        return this == PRE_MIGRATION || this == MIGRATION;
    }
}

